/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core.executors;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;

public class HttpClientHeaderWrapper
implements MultivaluedMap<String, Object> {
    private CaseInsensitiveMap cachedHeaders = new CaseInsensitiveMap();
    private HttpMethodBase httpMethod;
    private ResteasyProviderFactory factory;

    public HttpClientHeaderWrapper(HttpMethodBase httpMethod, ResteasyProviderFactory factory) {
        this.httpMethod = httpMethod;
        this.factory = factory;
    }

    public void sync() {
        for (Header header : this.httpMethod.getRequestHeaders()) {
            this.cachedHeaders.add(header.getName(), header.getValue());
        }
    }

    public void putSingle(String key, Object value) {
        this.cachedHeaders.putSingle(key, value);
        this.addResponseHeader(key, value);
    }

    public void add(String key, Object value) {
        this.cachedHeaders.add(key, value);
        this.addResponseHeader(key, value);
    }

    protected void addResponseHeader(String key, Object value) {
        RuntimeDelegate.HeaderDelegate<?> delegate = this.factory.createHeaderDelegate(value.getClass());
        if (delegate != null) {
            this.httpMethod.addRequestHeader(key.toLowerCase(), delegate.toString(value));
        } else {
            this.httpMethod.addRequestHeader(key.toLowerCase(), value.toString());
        }
    }

    public Object getFirst(String key) {
        return this.cachedHeaders.getFirst(key);
    }

    public int size() {
        return this.cachedHeaders.size();
    }

    public boolean isEmpty() {
        return this.cachedHeaders.isEmpty();
    }

    public boolean containsKey(Object o) {
        return this.cachedHeaders.containsKey(o);
    }

    public boolean containsValue(Object o) {
        return this.cachedHeaders.containsValue(o);
    }

    public List<Object> get(Object o) {
        return this.cachedHeaders.get(o);
    }

    public List<Object> put(String s, List<Object> objs) {
        for (Object obj : objs) {
            this.addResponseHeader(s, obj);
        }
        return this.cachedHeaders.put(s, objs);
    }

    public List<Object> remove(Object o) {
        throw new RuntimeException("Removing a header is illegal for an HttpServletResponse");
    }

    public void putAll(Map<? extends String, ? extends List<Object>> map) {
        for (Map.Entry<? extends String, ? extends List<Object>> entry : map.entrySet()) {
            List<Object> objs = entry.getValue();
            for (Object obj : objs) {
                this.add(entry.getKey(), obj);
            }
        }
    }

    public void clear() {
        throw new RuntimeException("Removing a header is illegal for an HttpServletResponse");
    }

    public Set<String> keySet() {
        return this.cachedHeaders.keySet();
    }

    public Collection<List<Object>> values() {
        return this.cachedHeaders.values();
    }

    public Set<Map.Entry<String, List<Object>>> entrySet() {
        return this.cachedHeaders.entrySet();
    }

    public boolean equals(Object o) {
        return this.cachedHeaders.equals(o);
    }

    public int hashCode() {
        return this.cachedHeaders.hashCode();
    }
}

