/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHistory;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;

public class HistoryHandler
extends CommandHandlerWithHelp {
    public HistoryHandler() {
        this("history");
    }

    public HistoryHandler(String command) {
        super(command);
    }

    @Override
    protected void handle(CommandContext ctx, String args) {
        if (args == null) {
            HistoryHandler.printHistory(ctx);
            return;
        }
        String lc = args.toLowerCase();
        if (lc.equals("disable")) {
            ctx.getHistory().setUseHistory(false);
        } else if (lc.equals("enable")) {
            ctx.getHistory().setUseHistory(true);
        } else if (lc.equals("clear")) {
            ctx.getHistory().clear();
        } else {
            ctx.printLine("Unexpected argument '" + args + '\"');
        }
    }

    private static void printHistory(CommandContext ctx) {
        CommandHistory history = ctx.getHistory();
        List<String> list = history.asList();
        for (String cmd : list) {
            ctx.printLine(cmd);
        }
        ctx.printLine("(The history is currently " + (history.isUseHistory() ? "enabled)" : "disabled)"));
    }
}

