/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;

public class LsHandler
extends CommandHandlerWithHelp {
    public LsHandler() {
        this("ls");
    }

    public LsHandler(String command) {
        super(command);
    }

    @Override
    protected void handle(CommandContext ctx, String args) {
        OperationRequestAddress address;
        boolean lSwitch = false;
        String nodePath = null;
        if (args != null) {
            String[] arr = args.split("\\s+");
            for (int i = 0; i < arr.length; ++i) {
                String arg = arr[i];
                if ("-l".equals(arg)) {
                    lSwitch = true;
                    continue;
                }
                nodePath = arg;
            }
        }
        if (nodePath != null) {
            address = new DefaultOperationRequestAddress(ctx.getPrefix());
            DefaultOperationCallbackHandler handler = new DefaultOperationCallbackHandler(address);
            try {
                ctx.getOperationRequestParser().parse(nodePath, handler);
            }
            catch (CommandFormatException e) {
                ctx.printLine(e.getLocalizedMessage());
            }
        } else {
            address = ctx.getPrefix();
        }
        List<String> names = address.endsOnType() ? ctx.getOperationCandidatesProvider().getNodeNames(address) : ctx.getOperationCandidatesProvider().getNodeTypes(address);
        if (lSwitch) {
            for (String name : names) {
                ctx.printLine(name);
            }
        } else {
            ctx.printColumns(names);
        }
    }
}

