/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.ChannelFactoryRegistry;

public class DefaultChannelFactoryRegistry
implements ChannelFactoryRegistry {
    private final AtomicReference<String> defaultStack = new AtomicReference();
    private final ConcurrentMap<String, ChannelFactory> stacks = new ConcurrentHashMap<String, ChannelFactory>();

    @Override
    public String getDefaultStack() {
        return this.defaultStack.get();
    }

    public void setDefaultStack(String stack) {
        this.defaultStack.set(stack);
    }

    @Override
    public Set<String> getStacks() {
        return Collections.unmodifiableSet(this.stacks.keySet());
    }

    @Override
    public ChannelFactory getChannelFactory(String stack) {
        ChannelFactory factory = (ChannelFactory)this.stacks.get(stack != null ? stack : this.getDefaultStack());
        if (factory == null) {
            throw new IllegalArgumentException(String.format("No channel factory found for %s stack", stack));
        }
        return factory;
    }

    @Override
    public boolean addChannelFactory(String stack, ChannelFactory factory) {
        this.defaultStack.compareAndSet(null, stack);
        return this.stacks.putIfAbsent(stack, factory) == null;
    }

    @Override
    public boolean removeChannelFactory(String stack) {
        return this.stacks.remove(stack) != null;
    }
}

