/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import javax.management.MBeanServer;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.ChannelFactoryRegistry;
import org.jboss.as.clustering.jgroups.DefaultChannelFactory;
import org.jboss.as.clustering.jgroups.ProtocolStackConfiguration;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryRegistryService;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ChannelFactoryService
implements Service<ChannelFactory> {
    private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();
    private final InjectedValue<ServerEnvironment> environment = new InjectedValue();
    private final InjectedValue<ChannelFactoryRegistry> registry = new InjectedValue();
    private final String name;
    private final ProtocolStackConfiguration configuration;
    private volatile ChannelFactory factory;

    public static ServiceName getServiceName(String name) {
        return ChannelFactoryRegistryService.SERVICE_NAME.append(new String[]{name});
    }

    public ChannelFactoryService(String name, ProtocolStackConfiguration configuration) {
        this.name = name;
        this.configuration = configuration;
    }

    ServiceBuilder<ChannelFactory> build(ServiceTarget target) {
        return target.addService(ChannelFactoryService.getServiceName(this.name), (Service)this).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(ChannelFactoryRegistryService.SERVICE_NAME, ChannelFactoryRegistry.class, this.registry).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.environment).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, this.mbeanServer);
    }

    public void start(StartContext context) throws StartException {
        this.factory = new DefaultChannelFactory(this.name, this.configuration, ((ServerEnvironment)this.environment.getValue()).getNodeName());
        ((ChannelFactoryRegistry)this.registry.getValue()).addChannelFactory(this.name, this.factory);
    }

    public void stop(StopContext context) {
        ((ChannelFactoryRegistry)this.registry.getValue()).removeChannelFactory(this.name);
        this.factory = null;
    }

    public ChannelFactory getValue() {
        return this.factory;
    }
}

