/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.service;

import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.jboss.as.naming.InMemoryNamingStore;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.context.GlobalNamespaceObjectFactory;
import org.jboss.as.naming.util.NameParser;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class GlobalContextService
implements Service<NamingStore> {
    private InMemoryNamingStore store;
    private String name;
    private InjectedValue<NamingStore> javaContext = new InjectedValue();

    public GlobalContextService(String name) {
        this.name = name;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.store = new InMemoryNamingStore();
        try {
            Reference globalReference = GlobalNamespaceObjectFactory.createReference(this.name, (Context)this.store.lookup(new CompositeName()));
            NamingStore javaContext = (NamingStore)this.javaContext.getValue();
            javaContext.rebind(null, NameParser.INSTANCE.parse(this.name), globalReference, Reference.class.getName());
        }
        catch (NamingException e) {
            throw new StartException("Failed to bind EE context: java:" + this.name, (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        NamingStore javaContext = (NamingStore)this.javaContext.getValue();
        try {
            javaContext.unbind(null, NameParser.INSTANCE.parse(this.name));
        }
        catch (NamingException e) {
            throw new IllegalStateException("Failed to unbind EE context: java:" + this.name, e);
        }
        finally {
            try {
                this.store.close();
                this.store = null;
            }
            catch (NamingException e) {
                throw new IllegalStateException("Failed to destroy root context", e);
            }
        }
    }

    public synchronized NamingStore getValue() throws IllegalStateException {
        return this.store;
    }

    public Injector<NamingStore> getJavaContextInjector() {
        return this.javaContext;
    }
}

