/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.SocketBindingGroupDescription;
import org.jboss.as.controller.operations.common.SocketBindingAddHandler;
import org.jboss.dmr.ModelNode;

public class SocketBindingRemoveHandler
implements ModelRemoveOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "remove";
    public static final SocketBindingRemoveHandler INSTANCE = new SocketBindingRemoveHandler();

    protected SocketBindingRemoveHandler() {
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress(opAddr);
        String name = address.getLastElement().getValue();
        ModelNode model = context.getSubModel();
        ModelNode compensating = SocketBindingAddHandler.getOperation(opAddr, model);
        return this.uninstallSocketBinding(name, model, context, resultHandler, compensating);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return SocketBindingGroupDescription.getSocketBindingRemoveOperation(locale);
    }

    protected OperationResult uninstallSocketBinding(String name, ModelNode model, OperationContext context, ResultHandler resultHandler, ModelNode compensatingOp) {
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensatingOp);
    }
}

