/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.addons.transports.httpserver;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http_jaxws_spi.HttpHandlerImpl;
import org.apache.cxf.transport.http_jaxws_spi.JAXWSHttpSpiDestination;
import org.jboss.ws.httpserver_httpspi.HttpExchangeDelegate;
import org.jboss.wsf.stack.cxf.addons.transports.httpserver.HttpServerEngine;
import org.jboss.wsf.stack.cxf.addons.transports.httpserver.HttpServerEngineFactory;
import org.jboss.wsf.stack.cxf.addons.transports.httpserver.HttpServerTransportFactory;

public class HttpServerDestination
extends JAXWSHttpSpiDestination {
    static final Logger LOG = LogUtils.getL7dLogger(HttpServerDestination.class);
    private static final long serialVersionUID = 1L;
    private HttpServerTransportFactory factory;
    private HttpServerEngineFactory serverEngineFactory;
    private HttpServerEngine engine;
    private URL url;

    public HttpServerDestination(Bus b, HttpServerTransportFactory factory, EndpointInfo ei) throws IOException {
        super(b, ei);
        this.factory = factory;
        this.serverEngineFactory = factory.getServerEngineFactory();
        HttpServerDestination.getAddressValue((EndpointInfo)ei, (boolean)true);
        this.url = new URL(ei.getAddress());
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void finalizeConfig() throws IOException {
        this.engine = this.serverEngineFactory.retrieveHttpServerEngine(this.url.getPort());
        if (this.engine == null) {
            this.engine = this.serverEngineFactory.createHttpServerEngine(this.url.getHost(), this.url.getPort(), this.url.getProtocol());
        }
        if (!this.url.getProtocol().equals(this.engine.getProtocol())) {
            throw new IllegalStateException("Port " + this.engine.getPort() + " is configured with wrong protocol \"" + this.engine.getProtocol() + "\" for \"" + this.url + "\"");
        }
    }

    protected void activate() {
        LOG.log(Level.FINE, "Activating receipt of incoming messages");
        String addr = this.endpointInfo.getAddress();
        try {
            new URL(addr);
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
        this.engine.addHandler(addr, new Handler(this, Thread.currentThread().getContextClassLoader()));
    }

    protected void deactivate() {
        LOG.log(Level.FINE, "Deactivating receipt of incoming messages");
        this.engine.removeHandler(this.endpointInfo.getAddress());
    }

    public void shutdown() {
        this.factory.removeDestination(this.endpointInfo);
        super.shutdown();
    }

    class Handler
    extends HttpHandlerImpl
    implements HttpHandler {
        private ClassLoader classLoader;

        public Handler(JAXWSHttpSpiDestination destination, ClassLoader classLoader) {
            super(destination);
            this.classLoader = classLoader;
        }

        @Override
        public void handle(HttpExchange ex) throws IOException {
            ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                this.handle((javax.xml.ws.spi.http.HttpExchange)new HttpExchangeDelegate(ex));
            }
            catch (Exception e) {
                LOG.throwing(Handler.class.getName(), "handle(com.sun.net.httpserver.HttpExchange ex)", e);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(origClassLoader);
            }
        }
    }
}

