/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sun.net.httpserver;

import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.jboss.sun.net.httpserver.SelectorCache;
import org.jboss.sun.net.httpserver.ServerConfig;
import org.jboss.sun.net.httpserver.ServerImpl;
import org.jboss.sun.net.httpserver.TimeSource;

class SSLStreams {
    SSLContext sslctx;
    SocketChannel chan;
    TimeSource time;
    ServerImpl server;
    SSLEngine engine;
    EngineWrapper wrapper;
    OutputStream os;
    InputStream is;
    static long readTimeout = ServerConfig.getReadTimeout();
    static long writeTimeout = ServerConfig.getWriteTimeout();
    Lock handshaking = new ReentrantLock();
    int app_buf_size;
    int packet_buf_size;

    SSLStreams(ServerImpl server, SSLContext sslctx, SocketChannel chan) throws IOException {
        this.server = server;
        this.time = server;
        this.sslctx = sslctx;
        this.chan = chan;
        InetSocketAddress addr = (InetSocketAddress)chan.socket().getRemoteSocketAddress();
        this.engine = sslctx.createSSLEngine(addr.getHostName(), addr.getPort());
        this.engine.setUseClientMode(false);
        HttpsConfigurator cfg = server.getHttpsConfigurator();
        this.configureEngine(cfg, addr);
        this.wrapper = new EngineWrapper(chan, this.engine);
    }

    private void configureEngine(HttpsConfigurator cfg, InetSocketAddress addr) {
        if (cfg != null) {
            Parameters params = new Parameters(cfg, addr);
            cfg.configure(params);
            SSLParameters sslParams = params.getSSLParameters();
            if (sslParams != null) {
                this.engine.setSSLParameters(sslParams);
            } else {
                if (params.getCipherSuites() != null) {
                    try {
                        this.engine.setEnabledCipherSuites(params.getCipherSuites());
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                this.engine.setNeedClientAuth(params.getNeedClientAuth());
                this.engine.setWantClientAuth(params.getWantClientAuth());
                if (params.getProtocols() != null) {
                    try {
                        this.engine.setEnabledProtocols(params.getProtocols());
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    void close() throws IOException {
        this.wrapper.close();
    }

    InputStream getInputStream() throws IOException {
        if (this.is == null) {
            this.is = new InputStream();
        }
        return this.is;
    }

    OutputStream getOutputStream() throws IOException {
        if (this.os == null) {
            this.os = new OutputStream();
        }
        return this.os;
    }

    SSLEngine getSSLEngine() {
        return this.engine;
    }

    void beginHandshake() throws SSLException {
        this.engine.beginHandshake();
    }

    private ByteBuffer allocate(BufType type) {
        return this.allocate(type, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer allocate(BufType type, int len) {
        assert (this.engine != null);
        SSLStreams sSLStreams = this;
        synchronized (sSLStreams) {
            int size;
            if (type == BufType.PACKET) {
                if (this.packet_buf_size == 0) {
                    SSLSession sess = this.engine.getSession();
                    this.packet_buf_size = sess.getPacketBufferSize();
                }
                if (len > this.packet_buf_size) {
                    this.packet_buf_size = len;
                }
                size = this.packet_buf_size;
            } else {
                if (this.app_buf_size == 0) {
                    SSLSession sess = this.engine.getSession();
                    this.app_buf_size = sess.getApplicationBufferSize();
                }
                if (len > this.app_buf_size) {
                    this.app_buf_size = len;
                }
                size = this.app_buf_size;
            }
            return ByteBuffer.allocate(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer realloc(ByteBuffer b, boolean flip, BufType type) {
        SSLStreams sSLStreams = this;
        synchronized (sSLStreams) {
            int nsize = 2 * b.capacity();
            ByteBuffer n = this.allocate(type, nsize);
            if (flip) {
                b.flip();
            }
            n.put(b);
            b = n;
        }
        return b;
    }

    public WrapperResult sendData(ByteBuffer src) throws IOException {
        WrapperResult r = null;
        while (src.remaining() > 0) {
            r = this.wrapper.wrapAndSend(src);
            SSLEngineResult.Status status = r.result.getStatus();
            if (status == SSLEngineResult.Status.CLOSED) {
                this.doClosure();
                return r;
            }
            SSLEngineResult.HandshakeStatus hs_status = r.result.getHandshakeStatus();
            if (hs_status == SSLEngineResult.HandshakeStatus.FINISHED || hs_status == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
            this.doHandshake(hs_status);
        }
        return r;
    }

    public WrapperResult recvData(ByteBuffer dst) throws IOException {
        WrapperResult r = null;
        assert (dst.position() == 0);
        while (dst.position() == 0) {
            r = this.wrapper.recvAndUnwrap(dst);
            dst = r.buf != dst ? r.buf : dst;
            SSLEngineResult.Status status = r.result.getStatus();
            if (status == SSLEngineResult.Status.CLOSED) {
                this.doClosure();
                return r;
            }
            SSLEngineResult.HandshakeStatus hs_status = r.result.getHandshakeStatus();
            if (hs_status == SSLEngineResult.HandshakeStatus.FINISHED || hs_status == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
            this.doHandshake(hs_status);
        }
        dst.flip();
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClosure() throws IOException {
        try {
            WrapperResult r;
            this.handshaking.lock();
            ByteBuffer tmp = this.allocate(BufType.APPLICATION);
            do {
                tmp.clear();
                tmp.flip();
                r = this.wrapper.wrapAndSendX(tmp, true);
            } while (r.result.getStatus() != SSLEngineResult.Status.CLOSED);
        }
        finally {
            this.handshaking.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doHandshake(SSLEngineResult.HandshakeStatus hs_status) throws IOException {
        try {
            this.handshaking.lock();
            ByteBuffer tmp = this.allocate(BufType.APPLICATION);
            while (hs_status != SSLEngineResult.HandshakeStatus.FINISHED && hs_status != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                WrapperResult r = null;
                switch (hs_status) {
                    case NEED_TASK: {
                        Runnable task;
                        while ((task = this.engine.getDelegatedTask()) != null) {
                            task.run();
                        }
                    }
                    case NEED_WRAP: {
                        tmp.clear();
                        tmp.flip();
                        r = this.wrapper.wrapAndSend(tmp);
                        break;
                    }
                    case NEED_UNWRAP: {
                        tmp.clear();
                        r = this.wrapper.recvAndUnwrap(tmp);
                        if (r.buf != tmp) {
                            tmp = r.buf;
                        }
                        assert (tmp.position() == 0);
                        break;
                    }
                }
                hs_status = r.result.getHandshakeStatus();
            }
        }
        finally {
            this.handshaking.unlock();
        }
    }

    class OutputStream
    extends java.io.OutputStream {
        ByteBuffer buf;
        boolean closed = false;
        byte[] single = new byte[1];

        OutputStream() {
            this.buf = SSLStreams.this.allocate(BufType.APPLICATION);
        }

        public void write(int b) throws IOException {
            this.single[0] = (byte)b;
            this.write(this.single, 0, 1);
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("output stream is closed");
            }
            while (len > 0) {
                int l = len > this.buf.capacity() ? this.buf.capacity() : len;
                this.buf.clear();
                this.buf.put(b, off, l);
                len -= l;
                off += l;
                this.buf.flip();
                WrapperResult r = SSLStreams.this.sendData(this.buf);
                if (r.result.getStatus() != SSLEngineResult.Status.CLOSED) continue;
                this.closed = true;
                if (len <= 0) continue;
                throw new IOException("output stream is closed");
            }
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
            WrapperResult r = null;
            SSLStreams.this.engine.closeOutbound();
            this.closed = true;
            SSLEngineResult.HandshakeStatus stat = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            this.buf.clear();
            while (stat == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                r = SSLStreams.this.wrapper.wrapAndSend(this.buf);
                stat = r.result.getHandshakeStatus();
            }
            assert (r.result.getStatus() == SSLEngineResult.Status.CLOSED);
        }
    }

    class InputStream
    extends java.io.InputStream {
        ByteBuffer bbuf;
        boolean closed = false;
        boolean eof = false;
        boolean needData = true;
        byte[] single = new byte[1];

        InputStream() {
            this.bbuf = SSLStreams.this.allocate(BufType.APPLICATION);
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("SSL stream is closed");
            }
            if (this.eof) {
                return 0;
            }
            int available = 0;
            if (!this.needData) {
                available = this.bbuf.remaining();
                boolean bl = this.needData = available == 0;
            }
            if (this.needData) {
                this.bbuf.clear();
                WrapperResult r = SSLStreams.this.recvData(this.bbuf);
                this.bbuf = r.buf == this.bbuf ? this.bbuf : r.buf;
                available = this.bbuf.remaining();
                if (available == 0) {
                    this.eof = true;
                    return 0;
                }
                this.needData = false;
            }
            if (len > available) {
                len = available;
            }
            this.bbuf.get(buf, off, len);
            return len;
        }

        public int available() throws IOException {
            return this.bbuf.remaining();
        }

        public boolean markSupported() {
            return false;
        }

        public void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }

        public long skip(long s) throws IOException {
            int n;
            if (this.closed) {
                throw new IOException("SSL stream is closed");
            }
            if (this.eof) {
                return 0L;
            }
            int ret = n;
            for (n = (int)s; n > 0; n -= this.bbuf.remaining()) {
                if (this.bbuf.remaining() >= n) {
                    this.bbuf.position(this.bbuf.position() + n);
                    return ret;
                }
                this.bbuf.clear();
                WrapperResult r = SSLStreams.this.recvData(this.bbuf);
                this.bbuf = r.buf == this.bbuf ? this.bbuf : r.buf;
            }
            return ret;
        }

        public void close() throws IOException {
            this.eof = true;
            SSLStreams.this.engine.closeInbound();
        }

        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        public int read() throws IOException {
            int n = this.read(this.single, 0, 1);
            if (n == 0) {
                return -1;
            }
            return this.single[0] & 0xFF;
        }
    }

    class EngineWrapper {
        SocketChannel chan;
        SSLEngine engine;
        SelectorCache sc;
        Selector write_selector;
        Selector read_selector;
        SelectionKey wkey;
        SelectionKey rkey;
        Object wrapLock;
        Object unwrapLock;
        ByteBuffer unwrap_src;
        ByteBuffer wrap_dst;
        boolean closed = false;
        int u_remaining;

        EngineWrapper(SocketChannel chan, SSLEngine engine) throws IOException {
            this.chan = chan;
            this.engine = engine;
            this.wrapLock = new Object();
            this.unwrapLock = new Object();
            this.unwrap_src = SSLStreams.this.allocate(BufType.PACKET);
            this.wrap_dst = SSLStreams.this.allocate(BufType.PACKET);
            this.sc = SelectorCache.getSelectorCache();
            this.write_selector = this.sc.getSelector();
            this.wkey = chan.register(this.write_selector, 4);
            this.read_selector = this.sc.getSelector();
            this.wkey = chan.register(this.read_selector, 1);
        }

        void close() throws IOException {
            this.sc.freeSelector(this.write_selector);
            this.sc.freeSelector(this.read_selector);
        }

        WrapperResult wrapAndSend(ByteBuffer src) throws IOException {
            return this.wrapAndSendX(src, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WrapperResult wrapAndSendX(ByteBuffer src, boolean ignoreClose) throws IOException {
            if (this.closed && !ignoreClose) {
                throw new IOException("Engine is closed");
            }
            WrapperResult r = new WrapperResult();
            Object object = this.wrapLock;
            synchronized (object) {
                SSLEngineResult.Status status;
                this.wrap_dst.clear();
                do {
                    r.result = this.engine.wrap(src, this.wrap_dst);
                    status = r.result.getStatus();
                    if (status != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
                    this.wrap_dst = SSLStreams.this.realloc(this.wrap_dst, true, BufType.PACKET);
                } while (status == SSLEngineResult.Status.BUFFER_OVERFLOW);
                if (status == SSLEngineResult.Status.CLOSED && !ignoreClose) {
                    this.closed = true;
                    return r;
                }
                if (r.result.bytesProduced() > 0) {
                    int l;
                    this.wrap_dst.flip();
                    assert (l == r.result.bytesProduced());
                    long currtime = SSLStreams.this.time.getTime();
                    long maxtime = currtime + writeTimeout;
                    for (l = this.wrap_dst.remaining(); l > 0; l -= this.chan.write(this.wrap_dst)) {
                        this.write_selector.select(writeTimeout);
                        currtime = SSLStreams.this.time.getTime();
                        if (currtime > maxtime) {
                            throw new SocketTimeoutException("write timed out");
                        }
                        this.write_selector.selectedKeys().clear();
                    }
                }
            }
            return r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WrapperResult recvAndUnwrap(ByteBuffer dst) throws IOException {
            boolean needData;
            SSLEngineResult.Status status = SSLEngineResult.Status.OK;
            WrapperResult r = new WrapperResult();
            r.buf = dst;
            if (this.closed) {
                throw new IOException("Engine is closed");
            }
            if (this.u_remaining > 0) {
                this.unwrap_src.compact();
                this.unwrap_src.flip();
                needData = false;
            } else {
                this.unwrap_src.clear();
                needData = true;
            }
            Object object = this.unwrapLock;
            synchronized (object) {
                do {
                    if (needData) {
                        int y;
                        long currTime = SSLStreams.this.time.getTime();
                        long maxtime = currTime + readTimeout;
                        do {
                            if (currTime > maxtime) {
                                throw new SocketTimeoutException("read timedout");
                            }
                            y = this.read_selector.select(readTimeout);
                            currTime = SSLStreams.this.time.getTime();
                        } while (y != 1);
                        this.read_selector.selectedKeys().clear();
                        int x = this.chan.read(this.unwrap_src);
                        if (x == -1) {
                            throw new IOException("connection closed for reading");
                        }
                        this.unwrap_src.flip();
                    }
                    r.result = this.engine.unwrap(this.unwrap_src, r.buf);
                    status = r.result.getStatus();
                    if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        if (this.unwrap_src.limit() == this.unwrap_src.capacity()) {
                            this.unwrap_src = SSLStreams.this.realloc(this.unwrap_src, false, BufType.PACKET);
                        } else {
                            this.unwrap_src.position(this.unwrap_src.limit());
                            this.unwrap_src.limit(this.unwrap_src.capacity());
                        }
                        needData = true;
                        continue;
                    }
                    if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        r.buf = SSLStreams.this.realloc(r.buf, true, BufType.APPLICATION);
                        needData = false;
                        continue;
                    }
                    if (status != SSLEngineResult.Status.CLOSED) continue;
                    this.closed = true;
                    r.buf.flip();
                    return r;
                } while (status != SSLEngineResult.Status.OK);
            }
            this.u_remaining = this.unwrap_src.remaining();
            return r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum BufType {
        PACKET,
        APPLICATION;

    }

    class WrapperResult {
        SSLEngineResult result;
        ByteBuffer buf;

        WrapperResult() {
        }
    }

    class Parameters
    extends HttpsParameters {
        InetSocketAddress addr;
        SSLParameters params;
        HttpsConfigurator cfg;

        Parameters(HttpsConfigurator cfg, InetSocketAddress addr) {
            this.addr = addr;
            this.cfg = cfg;
        }

        public InetSocketAddress getClientAddress() {
            return this.addr;
        }

        public HttpsConfigurator getHttpsConfigurator() {
            return this.cfg;
        }

        public void setSSLParameters(SSLParameters p) {
            this.params = p;
        }

        SSLParameters getSSLParameters() {
            return this.params;
        }
    }
}

