/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import java.util.Map;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractAnnotationEJBProcessor;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class ConcurrencyManagementAnnotationProcessor
extends AbstractAnnotationEJBProcessor<SessionBeanComponentDescription> {
    private static final Logger logger = Logger.getLogger(ConcurrencyManagementAnnotationProcessor.class);

    @Override
    protected Class<SessionBeanComponentDescription> getComponentDescriptionType() {
        return SessionBeanComponentDescription.class;
    }

    @Override
    protected void processAnnotations(ClassInfo beanClass, CompositeIndex compositeIndex, SessionBeanComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        if (!componentDescription.allowsConcurrentAccess()) {
            return;
        }
        Map annotationsOnBean = beanClass.annotations();
        if (annotationsOnBean == null || annotationsOnBean.isEmpty()) {
            return;
        }
        List concurrencyMgmtAnnotations = (List)annotationsOnBean.get(DotName.createSimple((String)ConcurrencyManagement.class.getName()));
        if (concurrencyMgmtAnnotations == null || concurrencyMgmtAnnotations.isEmpty()) {
            return;
        }
        if (concurrencyMgmtAnnotations.size() > 1) {
            throw new DeploymentUnitProcessingException("More than one @ConcurrencyManagement annotation found on bean: " + componentDescription.getEJBName());
        }
        AnnotationInstance concurrencyMgmtAnnotation = (AnnotationInstance)concurrencyMgmtAnnotations.get(0);
        if (!(concurrencyMgmtAnnotation.target() instanceof ClassInfo)) {
            throw new DeploymentUnitProcessingException("@ConcurrencyManagement can appear only on a class. Target: " + concurrencyMgmtAnnotation.target() + " is not a class");
        }
        AnnotationValue conMgmtAnnVal = concurrencyMgmtAnnotation.value();
        ConcurrencyManagementType concurrencyManagementType = ConcurrencyManagementType.valueOf((String)conMgmtAnnVal.asEnum());
        switch (concurrencyManagementType) {
            case CONTAINER: {
                componentDescription.containerManagedConcurrency();
                break;
            }
            case BEAN: {
                componentDescription.beanManagedConcurrency();
            }
            default: {
                throw new DeploymentUnitProcessingException("Unexpected concurrency management type: " + concurrencyManagementType + " on bean " + componentDescription.getEJBName());
            }
        }
        logger.debug((Object)(componentDescription.getEJBName() + " bean has been marked for " + componentDescription.getConcurrencyManagementType() + " concurrency management type"));
    }
}

