/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import java.util.Map;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.AbstractComponentConfigProcessor;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class TransactionManagementAnnotationProcessor
extends AbstractComponentConfigProcessor {
    private static final DotName TRANSACTION_MANAGEMENT_ANNOTATION_NAME = DotName.createSimple((String)TransactionManagement.class.getName());

    protected void processComponentConfig(DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, CompositeIndex index, AbstractComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)componentDescription.getComponentClassName()));
        if (classInfo == null) {
            return;
        }
        if (!EjbDeploymentMarker.isEjbDeployment(deploymentUnit) || !(componentDescription instanceof EJBComponentDescription)) {
            return;
        }
        this.processTransactionManagement(classInfo, index, (EJBComponentDescription)componentDescription);
    }

    protected void processTransactionManagement(ClassInfo classInfo, CompositeIndex index, EJBComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        List annotations;
        Map classAnnotations = classInfo.annotations();
        if (classAnnotations != null && (annotations = (List)classAnnotations.get(TRANSACTION_MANAGEMENT_ANNOTATION_NAME)) != null) {
            assert (annotations.size() == 1) : "@TransactionManagement can only be on the class itself";
            componentDescription.setTransactionManagementType(TransactionManagementType.valueOf((String)((AnnotationInstance)annotations.get(0)).value().asEnum()));
        }
    }
}

