/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.jboss.as.jpa.container.EntityManagerMetadata;
import org.jboss.as.jpa.container.SFSBXPCMap;
import org.jboss.as.jpa.spi.SFSBContextHandle;

public class SFSBCallStack {
    private static ThreadLocal<ArrayList<SFSBContextHandle>> SFSBInvocationStack = new ThreadLocal<ArrayList<SFSBContextHandle>>(){

        @Override
        protected synchronized ArrayList<SFSBContextHandle> initialValue() {
            return new ArrayList<SFSBContextHandle>();
        }
    };

    public static EntityManager findPersistenceContext(String puScopedName) {
        for (SFSBContextHandle handle : SFSBCallStack.currentSFSBCallStack()) {
            List<WeakReference<EntityManager>> xpcs = SFSBXPCMap.getINSTANCE().getXPC(handle);
            if (xpcs == null) continue;
            for (WeakReference<EntityManager> xpc_ref : xpcs) {
                EntityManager xpc = (EntityManager)xpc_ref.get();
                if (xpc == null || !((EntityManagerMetadata)xpc.unwrap(EntityManagerMetadata.class)).getScopedPuName().equals(puScopedName)) continue;
                return xpc;
            }
        }
        return null;
    }

    public static ArrayList<SFSBContextHandle> currentSFSBCallStack() {
        return SFSBInvocationStack.get();
    }

    public static void pushCall(SFSBContextHandle beanContextHandle) {
        SFSBCallStack.currentSFSBCallStack().add(beanContextHandle);
    }

    public static SFSBContextHandle popCall() {
        ArrayList<SFSBContextHandle> stack = SFSBCallStack.currentSFSBCallStack();
        SFSBContextHandle result = stack.remove(stack.size() - 1);
        stack.trimToSize();
        return result;
    }
}

