/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.handler;

import java.io.File;
import java.util.logging.Logger;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.event.suite.ClassEvent;
import org.jboss.arquillian.spi.event.suite.EventHandler;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public class ArchiveDeploymentExporter
implements EventHandler<ClassEvent> {
    private static final Logger log = Logger.getLogger(ArchiveDeploymentExporter.class.getName());

    public void callback(Context context, ClassEvent event) throws Exception {
        Archive deployment = (Archive)context.get(Archive.class);
        Configuration configuration = (Configuration)context.get(Configuration.class);
        if (deployment != null && configuration != null && configuration.getDeploymentExportPath() != null) {
            String exportPath = configuration.getDeploymentExportPath();
            File exportDir = new File(exportPath);
            if (exportDir.isFile()) {
                log.warning("Deployment export disabled. Export path points to an existing file: " + exportPath);
                return;
            }
            if (!exportDir.isDirectory() && !exportDir.mkdirs()) {
                log.warning("Deployment export directory could not be created: " + exportPath);
                return;
            }
            ((ZipExporter)deployment.as(ZipExporter.class)).exportZip(new File(exportDir, event.getTestClass().getName() + "_" + deployment.getName()), true);
        }
    }
}

