/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.AbstractComponent;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.ComponentInjector;
import org.jboss.as.ee.component.ComponentLifecycle;
import org.jboss.as.ee.component.LifecycleInterceptorFactory;
import org.jboss.as.ee.component.ResourceInjection;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;

public abstract class AbstractComponentConfiguration {
    private final String componentName;
    private final List<ComponentLifecycle> postConstructLifecycles = new ArrayList<ComponentLifecycle>();
    private final List<ComponentLifecycle> preDestroyLifecycles = new ArrayList<ComponentLifecycle>();
    private final List<LifecycleInterceptorFactory> postConstructInterceptorLifecycles = new ArrayList<LifecycleInterceptorFactory>();
    private final List<LifecycleInterceptorFactory> preDestroyInterceptorLifecycles = new ArrayList<LifecycleInterceptorFactory>();
    private final List<ResourceInjection> resourceInjections = new ArrayList<ResourceInjection>();
    private final Map<Class<?>, List<ResourceInjection>> interceptorResourceInjections = new IdentityHashMap();
    private final List<InterceptorFactory> componentSystemInterceptorFactories = new ArrayList<InterceptorFactory>();
    private final Map<Method, InterceptorFactory> interceptorFactoryMap = new IdentityHashMap<Method, InterceptorFactory>();
    private final Map<Class<?>, ProxyFactory<?>> proxyFactories = new IdentityHashMap();
    private final List<ComponentInjector> componentInjectors = new ArrayList<ComponentInjector>();
    private final Map<ServiceName, InjectedValue<Object>> dependencyInjections = new HashMap<ServiceName, InjectedValue<Object>>();
    private final Map<Class<?>, ServiceName> viewServices = new HashMap();
    private final Map<Class<?>, List<LifecycleInterceptorFactory>> interceptorPreDestroys = new HashMap();
    private Class<?> componentClass;
    private List<InterceptorFactory> componentInstanceSystemInterceptorFactories = new LinkedList<InterceptorFactory>();
    private Collection<Method> componentMethods;

    protected AbstractComponentConfiguration(AbstractComponentDescription description) {
        this.componentName = description.getComponentName();
    }

    public Class<?> getComponentClass() {
        return this.componentClass;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentClass(Class<?> componentClass) {
        this.componentClass = componentClass;
    }

    public void addPostConstructComponentLifecycle(ComponentLifecycle lifecycle) {
        this.postConstructLifecycles.add(lifecycle);
    }

    public void addPostConstructComponentLifecycles(Collection<ComponentLifecycle> lifecycles) {
        this.postConstructLifecycles.addAll(lifecycles);
    }

    List<ComponentLifecycle> getPostConstructComponentLifecycles() {
        return this.postConstructLifecycles;
    }

    public void addPostConstructLifecycle(LifecycleInterceptorFactory lifecycle) {
        this.postConstructInterceptorLifecycles.add(lifecycle);
    }

    public void addPostConstructLifecycles(Collection<LifecycleInterceptorFactory> lifecycles) {
        this.postConstructInterceptorLifecycles.addAll(lifecycles);
    }

    List<LifecycleInterceptorFactory> getPostConstructLifecycles() {
        return this.postConstructInterceptorLifecycles;
    }

    public void addPreDestroyComponentLifecycle(ComponentLifecycle lifecycle) {
        this.preDestroyLifecycles.add(lifecycle);
    }

    public void addPreDestroyComponentLifecycles(Collection<ComponentLifecycle> lifecycles) {
        this.preDestroyLifecycles.addAll(lifecycles);
    }

    List<ComponentLifecycle> getPreDestroyComponentLifecycles() {
        return this.preDestroyLifecycles;
    }

    public void addPreDestroyLifecycle(LifecycleInterceptorFactory lifecycle) {
        this.preDestroyInterceptorLifecycles.add(lifecycle);
    }

    public void addPreDestroyLifecycles(Collection<LifecycleInterceptorFactory> lifecycles) {
        this.preDestroyInterceptorLifecycles.addAll(lifecycles);
    }

    List<LifecycleInterceptorFactory> getPreDestroyLifecycles() {
        return this.preDestroyInterceptorLifecycles;
    }

    public void addInterceptorResourceInjection(Class<?> interceptorClass, List<ResourceInjection> resourceInjections) {
        this.interceptorResourceInjections.put(interceptorClass, new ArrayList<ResourceInjection>(resourceInjections));
    }

    public List<ResourceInjection> getInterceptorResourceInjections(Class<?> interceptorClass) {
        return this.interceptorResourceInjections.get(interceptorClass);
    }

    List<ResourceInjection> getResourceInjections() {
        return this.resourceInjections;
    }

    protected List<InterceptorFactory> getComponentSystemInterceptorFactories() {
        return this.componentSystemInterceptorFactories;
    }

    Map<Method, InterceptorFactory> getInterceptorFactoryMap() {
        return this.interceptorFactoryMap;
    }

    Map<Class<?>, ProxyFactory<?>> getProxyFactories() {
        return this.proxyFactories;
    }

    public void addComponentInjector(ComponentInjector injector) {
        this.componentInjectors.add(injector);
    }

    public List<ComponentInjector> getComponentInjectors() {
        return Collections.unmodifiableList(this.componentInjectors);
    }

    public Map<Class<?>, List<LifecycleInterceptorFactory>> getInterceptorPreDestroys() {
        return this.interceptorPreDestroys;
    }

    public InjectedValue<?> getInjection(ServiceName dependencyName) {
        InjectedValue<Object> injection = this.dependencyInjections.get(dependencyName);
        if (injection == null) {
            throw new IllegalStateException("No injection found for dependency " + dependencyName);
        }
        return injection;
    }

    public <T> T getInjectionValue(ServiceName dependencyName, Class<T> valueType) {
        return valueType.cast(this.getInjection(dependencyName).getValue());
    }

    Map<ServiceName, InjectedValue<Object>> getDependencyInjections() {
        return this.dependencyInjections;
    }

    protected Map<Class<?>, ServiceName> getViewServices() {
        return this.viewServices;
    }

    public abstract AbstractComponent constructComponent();

    protected void addComponentInstanceSystemInterceptorFactory(InterceptorFactory factory) {
        this.componentInstanceSystemInterceptorFactories.add(factory);
    }

    List<? extends InterceptorFactory> getComponentInstanceSystemInterceptorFactories() {
        return this.componentInstanceSystemInterceptorFactories;
    }

    @Deprecated
    Collection<Method> getComponentMethods() {
        return this.componentMethods;
    }

    @Deprecated
    void setComponentMethods(Collection<Method> componentMethods) {
        this.componentMethods = componentMethods;
    }
}

