/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionTargetDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.metadata.javaee.support.ResourceInjectionMetaDataWithDescriptions;
import org.jboss.modules.Module;

public abstract class AbstractDeploymentDescriptorBindingsProcessor
implements DeploymentUnitProcessor {
    public final void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentDescriptorEnvironment environment = (DeploymentDescriptorEnvironment)deploymentUnit.getAttachment(Attachments.MODULE_DEPLOYMENT_DESCRIPTOR_ENVIRONMENT);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        EEModuleDescription description = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (description == null) {
            return;
        }
        if (environment != null) {
            List<BindingDescription> bindings = this.processDescriptorEntries(deploymentUnit, environment, description, null, (ClassLoader)module.getClassLoader(), deploymentReflectionIndex);
            description.getBindingsContainer().addBindings(bindings);
        }
        for (AbstractComponentDescription componentDescription : description.getComponentDescriptions()) {
            if (componentDescription.getDeploymentDescriptorEnvironment() == null) continue;
            List<BindingDescription> bindings = this.processDescriptorEntries(deploymentUnit, componentDescription.getDeploymentDescriptorEnvironment(), description, null, (ClassLoader)module.getClassLoader(), deploymentReflectionIndex);
            componentDescription.addBindings(bindings);
        }
    }

    protected abstract List<BindingDescription> processDescriptorEntries(DeploymentUnit var1, DeploymentDescriptorEnvironment var2, EEModuleDescription var3, AbstractComponentDescription var4, ClassLoader var5, DeploymentReflectionIndex var6) throws DeploymentUnitProcessingException;

    public void undeploy(DeploymentUnit context) {
    }

    protected Class<?> processInjectionTargets(ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, ResourceInjectionMetaDataWithDescriptions entry, BindingDescription description, Class<?> classType) throws DeploymentUnitProcessingException {
        if (entry.getInjectionTargets() != null) {
            for (ResourceInjectionTargetMetaData injectionTarget : entry.getInjectionTargets()) {
                Class<?> current;
                Class<?> injectionTargetClass;
                try {
                    injectionTargetClass = classLoader.loadClass(injectionTarget.getInjectionTargetClass());
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Could not load " + injectionTarget.getInjectionTargetClass() + " referenced in env-entry injection point ", (Throwable)e);
                }
                ClassReflectionIndex index = deploymentReflectionIndex.getClassIndex(injectionTargetClass);
                String methodName = "set" + injectionTarget.getInjectionTargetName().substring(0, 1).toUpperCase() + injectionTarget.getInjectionTargetName().substring(1);
                boolean methodFound = false;
                Method method = null;
                Field field = null;
                Class<?> injectionTargetType = null;
                String memberName = injectionTarget.getInjectionTargetName();
                for (current = injectionTargetClass; current != Object.class && current != null && !methodFound; current = current.getSuperclass()) {
                    Collection methods = index.getAllMethods(methodName);
                    for (Method m : methods) {
                        if (m.getParameterTypes().length != 1 || m.isBridge() || m.isSynthetic()) continue;
                        if (methodFound) {
                            throw new DeploymentUnitProcessingException("Two setter methods for " + injectionTarget.getInjectionTargetName() + " on class " + injectionTarget.getInjectionTargetClass() + " found when applying <injection-target> for env-entry");
                        }
                        methodFound = true;
                        method = m;
                        injectionTargetType = m.getParameterTypes()[0];
                        memberName = methodName;
                    }
                }
                if (method == null) {
                    for (current = injectionTargetClass; current != Object.class && current != null && field == null; current = current.getSuperclass()) {
                        field = index.getField(injectionTarget.getInjectionTargetName());
                        if (field == null) continue;
                        injectionTargetType = field.getType();
                        memberName = injectionTarget.getInjectionTargetName();
                        break;
                    }
                }
                if (field == null && method == null) {
                    throw new DeploymentUnitProcessingException("Could not resolve injection point " + injectionTarget.getInjectionTargetName() + " on class " + injectionTarget.getInjectionTargetClass() + " specified in web.xml");
                }
                if (classType != null) {
                    if (!classType.isAssignableFrom(injectionTargetType)) {
                        throw new DeploymentUnitProcessingException("Injection target " + injectionTarget.getInjectionTargetName() + " on class " + injectionTarget.getInjectionTargetClass() + " is not compatible with the type of injection");
                    }
                } else {
                    classType = injectionTargetType;
                }
                InjectionTargetDescription injectionTargetDescription = new InjectionTargetDescription();
                injectionTargetDescription.setClassName(injectionTarget.getInjectionTargetClass());
                if (method == null) {
                    injectionTargetDescription.setType(InjectionTargetDescription.Type.FIELD);
                } else {
                    injectionTargetDescription.setType(InjectionTargetDescription.Type.METHOD);
                }
                injectionTargetDescription.setName(memberName);
                injectionTargetDescription.setValueClassName(classType.getName());
                description.getInjectionTargetDescriptions().add(injectionTargetDescription);
            }
        }
        return classType;
    }
}

