/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.BindingsContainer;
import org.jboss.as.ee.component.InjectionFactory;

public final class EEModuleDescription {
    private final String appName;
    private volatile String moduleName;
    private final Map<String, AbstractComponentDescription> componentsByName = new HashMap<String, AbstractComponentDescription>();
    private final Map<String, AbstractComponentDescription> componentsByClassName = new HashMap<String, AbstractComponentDescription>();
    private final List<InjectionFactory> injectionFactories = new ArrayList<InjectionFactory>();
    private final Map<String, Set<AbstractComponentDescription>> componentsByViewName = new HashMap<String, Set<AbstractComponentDescription>>();
    private final BindingsContainer bindingsContainer;

    public EEModuleDescription(String appName, String moduleName) {
        this.appName = appName;
        this.moduleName = moduleName;
        this.bindingsContainer = new BindingsContainer();
    }

    public void addComponent(AbstractComponentDescription description) {
        String componentName = description.getComponentName();
        String componentClassName = description.getComponentClassName();
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is null");
        }
        if (componentClassName == null) {
            throw new IllegalArgumentException("componentClassName is null");
        }
        if (this.componentsByName.containsKey(componentName)) {
            throw new IllegalArgumentException("A component named '" + componentName + "' is already defined in this module");
        }
        if (this.componentsByClassName.containsKey(componentClassName)) {
            throw new IllegalArgumentException("A component of class " + componentClassName + " is already defined in this module");
        }
        this.componentsByName.put(componentName, description);
        this.componentsByClassName.put(componentClassName, description);
        for (String viewName : description.getViewClassNames()) {
            Set<AbstractComponentDescription> viewComponents = this.componentsByViewName.get(viewName);
            if (viewComponents == null) {
                viewComponents = new HashSet<AbstractComponentDescription>();
                this.componentsByViewName.put(viewName, viewComponents);
            }
            viewComponents.add(description);
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public AbstractComponentDescription getComponentByName(String name) {
        return this.componentsByName.get(name);
    }

    public AbstractComponentDescription getComponentByClassName(String className) {
        return this.componentsByClassName.get(className);
    }

    public Collection<AbstractComponentDescription> getComponentDescriptions() {
        return this.componentsByName.values();
    }

    public void addInjectionFactory(InjectionFactory factory) {
        this.injectionFactories.add(factory);
    }

    public List<InjectionFactory> getInjectionFactories() {
        return Collections.unmodifiableList(this.injectionFactories);
    }

    public Map<String, Set<AbstractComponentDescription>> getComponentsByViewName() {
        return Collections.unmodifiableMap(this.componentsByViewName);
    }

    public Set<AbstractComponentDescription> getComponentsForViewName(String name) {
        return this.componentsByViewName.get(name);
    }

    public BindingsContainer getBindingsContainer() {
        return this.bindingsContainer;
    }
}

