/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.interceptor.InvocationContext;
import org.jboss.as.ee.component.ComponentLifecycle;
import org.jboss.as.ee.component.ComponentLifecycleMethod;
import org.jboss.as.ee.component.InterceptorMethodDescription;
import org.jboss.as.ee.component.LifecycleInterceptorFactory;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorInstanceFactory;
import org.jboss.invocation.MethodInterceptorFactory;
import org.jboss.invocation.SimpleInterceptorInstanceFactory;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class LifecycleInterceptorBuilder {
    public static List<LifecycleInterceptorFactory> createLifecycleInterceptors(List<InterceptorMethodDescription> lifecycleDescriptions, Module module, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        ArrayList<LifecycleInterceptorFactory> lifecycleInterceptors = new ArrayList<LifecycleInterceptorFactory>(lifecycleDescriptions.size());
        ModuleClassLoader classLoader = module.getClassLoader();
        for (InterceptorMethodDescription lifecycleConfiguration : lifecycleDescriptions) {
            try {
                if (lifecycleConfiguration.isDeclaredOnTargetClass()) continue;
                lifecycleInterceptors.add(LifecycleInterceptorBuilder.createInterceptorLifecycle((ClassLoader)classLoader, lifecycleConfiguration, deploymentReflectionIndex));
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException("Failed to create lifecycle interceptor instance: " + lifecycleConfiguration.getIdentifier().getName(), (Throwable)e);
            }
        }
        return lifecycleInterceptors;
    }

    public static List<ComponentLifecycle> createLifecycless(List<InterceptorMethodDescription> descriptions, Module module, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        ArrayList<ComponentLifecycle> lifecycles = new ArrayList<ComponentLifecycle>(descriptions.size());
        ModuleClassLoader classLoader = module.getClassLoader();
        for (InterceptorMethodDescription lifecycleConfiguration : descriptions) {
            try {
                if (!lifecycleConfiguration.isDeclaredOnTargetClass()) continue;
                lifecycles.add(LifecycleInterceptorBuilder.createLifecycle((ClassLoader)classLoader, lifecycleConfiguration, deploymentReflectionIndex));
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException("Failed to create lifecycle interceptor instance: " + lifecycleConfiguration.getIdentifier().getName(), (Throwable)e);
            }
        }
        return lifecycles;
    }

    private static ComponentLifecycle createLifecycle(ClassLoader classLoader, InterceptorMethodDescription lifecycleConfiguration, DeploymentReflectionIndex deploymentReflectionIndex) throws NoSuchMethodException, ClassNotFoundException {
        Class<?> interceptorClass = classLoader.loadClass(lifecycleConfiguration.getDeclaringClass());
        Method lifecycleMethod = deploymentReflectionIndex.getClassIndex(interceptorClass).getMethod(Void.TYPE, lifecycleConfiguration.getIdentifier().getName(), new Class[0]);
        return new ComponentLifecycleMethod(lifecycleMethod);
    }

    private static LifecycleInterceptorFactory createInterceptorLifecycle(ClassLoader classLoader, InterceptorMethodDescription lifecycleConfiguration, DeploymentReflectionIndex deploymentReflectionIndex) throws NoSuchMethodException, ClassNotFoundException {
        Class<?> declaringClass = classLoader.loadClass(lifecycleConfiguration.getDeclaringClass());
        Class<?> instanceClass = classLoader.loadClass(lifecycleConfiguration.getInstanceClass());
        Method lifecycleMethod = deploymentReflectionIndex.getClassIndex(declaringClass).getMethod(Void.TYPE, lifecycleConfiguration.getIdentifier().getName(), new Class[]{InvocationContext.class});
        MethodInterceptorFactory delegate = new MethodInterceptorFactory((InterceptorInstanceFactory)new SimpleInterceptorInstanceFactory(instanceClass), lifecycleMethod);
        return new LifecycleInterceptorFactory((InterceptorFactory)delegate, lifecycleMethod);
    }
}

