/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.BindingSourceDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.naming.ContextNames;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public final class LookupBindingSourceDescription
extends BindingSourceDescription {
    private final String lookupName;
    private final ServiceName sourceServiceName;

    public LookupBindingSourceDescription(String lookupName, AbstractComponentDescription componentDescription) {
        this.lookupName = lookupName;
        if (!lookupName.startsWith("java:")) {
            throw new RuntimeException("lookup name " + lookupName + " not supported, lookup in @Resource annotation must start with java in " + componentDescription.getComponentClassName());
        }
        String compName = componentDescription.getNamingMode() == ComponentNamingMode.CREATE ? componentDescription.getComponentName() : componentDescription.getModuleName();
        String moduleName = componentDescription.getModuleName();
        String appName = componentDescription.getApplicationName();
        this.sourceServiceName = ContextNames.serviceNameOfContext(appName, moduleName, compName, lookupName);
    }

    public LookupBindingSourceDescription(String lookupName, EEModuleDescription moduleDescription) {
        this.lookupName = lookupName;
        if (!lookupName.startsWith("java:")) {
            throw new RuntimeException("lookup name " + lookupName + " not supported, lookup in @Resource annotation must start with java in " + moduleDescription.getModuleName());
        }
        String compName = moduleDescription.getModuleName();
        String moduleName = moduleDescription.getModuleName();
        String appName = moduleDescription.getAppName();
        this.sourceServiceName = ContextNames.serviceNameOfContext(appName, moduleName, compName, lookupName);
    }

    @Override
    public void getResourceValue(BindingDescription bindingDescription, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) {
        serviceBuilder.addDependency(this.sourceServiceName, ManagedReferenceFactory.class, injector);
    }
}

