/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.as.ee.component.FieldResourceInjection;
import org.jboss.as.ee.component.InjectionTargetDescription;
import org.jboss.as.ee.component.MethodResourceInjection;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.msc.value.Value;

public interface ResourceInjection {
    public void inject(Object var1);

    public static class Factory {
        private Factory() {
        }

        public static ResourceInjection create(InjectionTargetDescription resourceConfiguration, Class<?> beanClass, DeploymentReflectionIndex deploymentReflectionIndex, Value<ManagedReferenceFactory> value) {
            Class<?> argClass;
            try {
                argClass = beanClass.getClassLoader().loadClass(resourceConfiguration.getValueClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Invalid resource injection configuration.", e);
            }
            ClassReflectionIndex classReflectionIndex = deploymentReflectionIndex.getClassIndex(beanClass);
            String memberName = resourceConfiguration.getName();
            switch (resourceConfiguration.getType()) {
                case FIELD: {
                    Field field = Factory.findField(deploymentReflectionIndex, classReflectionIndex, memberName);
                    if (field == null) {
                        throw new IllegalArgumentException("Field not found - Invalid injection into field '" + memberName + "' of " + beanClass);
                    }
                    if (!field.getType().isAssignableFrom(argClass)) {
                        throw new IllegalArgumentException("Field type " + field.getType() + " is not assignable from " + argClass + " , injection into class " + beanClass + " failed");
                    }
                    return new FieldResourceInjection(field, value);
                }
                case METHOD: {
                    Method method = Factory.findMethod(deploymentReflectionIndex, classReflectionIndex, Void.TYPE, memberName, argClass);
                    if (method == null) {
                        throw new IllegalArgumentException("Invalid injection - Method void " + memberName + "(" + argClass.getName() + ")" + " not found on " + beanClass);
                    }
                    if (!method.getParameterTypes()[0].isAssignableFrom(argClass)) {
                        throw new IllegalArgumentException("Field type " + method.getParameterTypes()[0] + " is not assignable from " + argClass + " , injection into class " + beanClass + " failed");
                    }
                    return new MethodResourceInjection(method, value);
                }
            }
            throw new IllegalArgumentException("Resource injection is allowed only on field and method types. Can't handle " + (Object)((Object)resourceConfiguration.getType()));
        }

        private static Field findField(DeploymentReflectionIndex deploymentReflectionIndex, ClassReflectionIndex<?> classReflectionIndex, String fieldName) {
            ClassReflectionIndex superClassIndex;
            Field field = classReflectionIndex.getField(fieldName);
            if (field != null) {
                return field;
            }
            Class superClass = classReflectionIndex.getIndexedClass().getSuperclass();
            if (superClass != null && (superClassIndex = deploymentReflectionIndex.getClassIndex(superClass)) != null) {
                return Factory.findField(deploymentReflectionIndex, superClassIndex, fieldName);
            }
            return null;
        }

        private static Method findMethod(DeploymentReflectionIndex deploymentReflectionIndex, ClassReflectionIndex<?> classReflectionIndex, Class<?> returnType, String methodName, Class<?> ... paramTypes) {
            ClassReflectionIndex superClassIndex;
            Method method = classReflectionIndex.getMethod(returnType, methodName, (Class[])paramTypes);
            if (method != null) {
                return method;
            }
            Class superClass = classReflectionIndex.getIndexedClass().getSuperclass();
            if (superClass != null && (superClassIndex = deploymentReflectionIndex.getClassIndex(superClass)) != null) {
                return Factory.findMethod(deploymentReflectionIndex, superClassIndex, returnType, methodName, paramTypes);
            }
            return null;
        }
    }
}

