/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.naming;

import org.jboss.as.naming.deployment.JndiName;
import org.jboss.msc.service.ServiceName;

public class ContextNames
extends org.jboss.as.naming.deployment.ContextNames {
    public static final JndiName GLOBAL_CONTEXT_NAME = JndiName.of((String)"java:global");
    public static final ServiceName GLOBAL_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"global"});
    public static final JndiName APPLICATION_CONTEXT_NAME = JndiName.of((String)"java:app");
    public static final ServiceName APPLICATION_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"app"});
    public static final JndiName MODULE_CONTEXT_NAME = JndiName.of((String)"java:module");
    public static final ServiceName MODULE_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"module"});
    public static final JndiName COMPONENT_CONTEXT_NAME = JndiName.of((String)"java:comp");
    public static final ServiceName COMPONENT_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"comp"});

    public static ServiceName contextServiceNameOfComponent(String app, String module, String comp) {
        return COMPONENT_CONTEXT_SERVICE_NAME.append(new String[]{app, module, comp});
    }

    public static ServiceName contextServiceNameOfModule(String app, String module) {
        return MODULE_CONTEXT_SERVICE_NAME.append(new String[]{app, module});
    }

    public static ServiceName contextServiceNameOfApplication(String app) {
        return APPLICATION_CONTEXT_SERVICE_NAME.append(new String[]{app});
    }

    public static ServiceName serviceNameOfContext(String app, String module, String comp, String context) {
        if (context.startsWith("java:")) {
            int i = context.indexOf(47);
            String namespace = i == -1 ? context.substring(5) : context.substring(5, i);
            if (namespace.equals("global")) {
                return GLOBAL_CONTEXT_SERVICE_NAME.append(new String[]{context.substring(12)});
            }
            if (namespace.equals("app")) {
                return ContextNames.contextServiceNameOfApplication(app).append(new String[]{context.substring(9)});
            }
            if (namespace.equals("module")) {
                return ContextNames.contextServiceNameOfModule(app, module).append(new String[]{context.substring(12)});
            }
            if (namespace.equals("comp")) {
                return ContextNames.contextServiceNameOfComponent(app, module, comp).append(new String[]{context.substring(10)});
            }
            return null;
        }
        return null;
    }
}

