/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.domain.http.server.ConsoleHandler;
import org.jboss.as.domain.http.server.multipart.BoundaryDelimitedInputStream;
import org.jboss.as.domain.http.server.multipart.MultipartHeader;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class DomainHttpServer
implements HttpHandler {
    private static final int HTTP_INTERNAL_SERVER_ERROR_STATUS = 500;
    private static final String DOMAIN_API_CONTEXT = "/domain-api";
    private static final String UPLOAD_REQUEST = "/domain-api/add-content";
    private static final String POST_REQUEST_METHOD = "POST";
    private static final String GET_REQUEST_METHOD = "GET";
    private static final String MULTIPART_FORM_DATA_CONTENT_TYPE = "application/octet-stream";
    private static final String UPLOAD_TEMP_DIRECTORY = "uploads";
    private static final int UPLOAD_BUFFER_SIZE = 1024;
    private final byte[] POST_BOUNDARY = new byte[]{13, 10, 45, 45};
    private final byte[] POST_HEADER_BOUNDARY = new byte[]{13, 10, 13, 10};
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.domain.http.api");
    private HttpServer server;
    private ModelController modelController;
    private final File serverTempDir;

    DomainHttpServer(HttpServer server, ModelController modelController, File serverTempDir) {
        this.server = server;
        this.modelController = modelController;
        this.serverTempDir = new File(serverTempDir, UPLOAD_TEMP_DIRECTORY);
        if (!this.serverTempDir.exists()) {
            this.serverTempDir.mkdir();
        }
    }

    @Override
    public void handle(HttpExchange http) throws IOException {
        URI request = http.getRequestURI();
        String requestMethod = http.getRequestMethod();
        if (POST_REQUEST_METHOD.equals(requestMethod) && UPLOAD_REQUEST.equals(request.getPath())) {
            this.processUploadRequest(http);
        } else {
            this.processRequest(http);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUploadRequest(HttpExchange http) throws IOException {
        File tempUploadFile = null;
        ModelNode response = null;
        int status = 200;
        try {
            tempUploadFile = this.extractPostContent(http);
            ModelNode dmr = new ModelNode();
            dmr.get("operation").set("upload-deployment-url");
            dmr.get("address").setEmptyList();
            dmr.get("url").set(tempUploadFile.toURI().toURL().toString());
            response = this.modelController.execute(OperationBuilder.Factory.create((ModelNode)dmr).build());
        }
        catch (Throwable t) {
            log.error((Object)"Unexpected error executing deployment upload request", t);
            http.sendResponseHeaders(500, -1L);
            return;
        }
        finally {
            if (tempUploadFile != null && tempUploadFile.exists()) {
                tempUploadFile.delete();
            }
        }
        this.writeResponse(http, false, false, response, status, false);
    }

    private void processRequest(HttpExchange http) throws IOException {
        ModelNode response;
        URI request = http.getRequestURI();
        String requestMethod = http.getRequestMethod();
        boolean isGet = GET_REQUEST_METHOD.equals(requestMethod);
        if (!isGet && !POST_REQUEST_METHOD.equals(requestMethod)) {
            http.sendResponseHeaders(405, -1L);
            return;
        }
        ModelNode dmr = null;
        int status = 200;
        Headers requestHeaders = http.getRequestHeaders();
        boolean encode = "application/dmr-encoded".equals(requestHeaders.getFirst("Accept")) || "application/dmr-encoded".equals(requestHeaders.getFirst("Content-Type"));
        try {
            dmr = isGet ? this.convertGetRequest(request) : this.convertPostRequest(http.getRequestBody(), encode);
            response = this.modelController.execute(OperationBuilder.Factory.create((ModelNode)dmr).build());
        }
        catch (Throwable t) {
            log.error((Object)"Unexpected error executing model request", t);
            http.sendResponseHeaders(500, -1L);
            return;
        }
        if (response.hasDefined("outcome") && "failed".equals(response.get("outcome").asString())) {
            status = 500;
        }
        boolean pretty = dmr.hasDefined("json.pretty") && dmr.get("json.pretty").asBoolean();
        this.writeResponse(http, isGet, pretty, response, status, encode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(HttpExchange http, boolean isGet, boolean pretty, ModelNode response, int status, boolean encode) throws IOException {
        Headers responseHeaders = http.getResponseHeaders();
        responseHeaders.add("Content-Type", encode ? "application/dmr-encoded" : "application/json");
        responseHeaders.add("Access-Control-Allow-Origin", "*");
        http.sendResponseHeaders(status, 0L);
        OutputStream out = http.getResponseBody();
        PrintWriter print = new PrintWriter(out);
        if (isGet && status == 200) {
            response = response.get("result");
        }
        try {
            if (encode) {
                response.writeBase64(out);
            } else {
                response.writeJSONString(print, !pretty);
            }
        }
        finally {
            print.flush();
            out.flush();
            this.safeClose(print);
            this.safeClose(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extractPostContent(HttpExchange http) throws IOException {
        BoundaryDelimitedInputStream iStream = new BoundaryDelimitedInputStream(http.getRequestBody(), this.POST_BOUNDARY);
        File tempUploadFile = File.createTempFile("upload", ".tmp", this.serverTempDir);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tempUploadFile));
        byte[] buffer = new byte[1024];
        boolean isDeploymentPart = false;
        try {
            while (!isDeploymentPart && !iStream.isOuterStreamClosed()) {
                int numRead = 0;
                MultipartHeader header = this.readHeader(iStream);
                if (header == null) continue;
                isDeploymentPart = MULTIPART_FORM_DATA_CONTENT_TYPE.equals(header.getContentType());
                while (numRead != -1) {
                    numRead = iStream.read(buffer);
                    if (numRead <= 0 || !isDeploymentPart) continue;
                    bos.write(buffer, 0, numRead);
                }
            }
        }
        finally {
            bos.flush();
            this.safeClose(bos);
        }
        return tempUploadFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultipartHeader readHeader(BoundaryDelimitedInputStream boundaryStream) throws IOException {
        MultipartHeader currentHeader = null;
        if (!boundaryStream.isOuterStreamClosed()) {
            int separatorCounter = 0;
            byte[] separatorBuffer = new byte[this.POST_HEADER_BOUNDARY.length];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                while (separatorCounter < this.POST_HEADER_BOUNDARY.length) {
                    int current = boundaryStream.read();
                    if (current == this.POST_HEADER_BOUNDARY[separatorCounter]) {
                        separatorBuffer[separatorCounter] = (byte)current;
                        ++separatorCounter;
                        continue;
                    }
                    if (separatorCounter > 0) {
                        bos.write(separatorBuffer, 0, separatorCounter);
                    }
                    bos.write(current);
                    separatorCounter = 0;
                }
            }
            finally {
                bos.flush();
                bos.close();
            }
            currentHeader = new MultipartHeader(bos.toByteArray());
        }
        return currentHeader;
    }

    private void safeClose(Closeable close) {
        try {
            close.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private ModelNode convertPostRequest(InputStream stream, boolean encode) throws IOException {
        return encode ? ModelNode.fromBase64((InputStream)stream) : ModelNode.fromJSONStream((InputStream)stream);
    }

    private ModelNode convertGetRequest(URI request) {
        ArrayList<String> pathSegments = this.decodePath(request.getRawPath());
        Map<String, String> queryParameters = this.decodeQuery(request.getRawQuery());
        GetOperation operation = null;
        ModelNode dmr = new ModelNode();
        for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("operation".equals(key)) {
                try {
                    operation = GetOperation.valueOf(value.toUpperCase().replace('-', '_'));
                    value = operation.realOperation();
                }
                catch (Exception e) {
                    continue;
                }
            }
            dmr.get(entry.getKey()).set(value);
        }
        if (operation == null) {
            operation = GetOperation.RESOURCE;
            dmr.get("operation").set(operation.realOperation);
        }
        if (operation == GetOperation.RESOURCE && !dmr.has("recursive")) {
            dmr.get("recursive").set(false);
        }
        ModelNode list = dmr.get("address").setEmptyList();
        for (int i = 1; i < pathSegments.size() - 1; i += 2) {
            list.add(pathSegments.get(i), pathSegments.get(i + 1));
        }
        return dmr;
    }

    private ArrayList<String> decodePath(String path) {
        int j;
        if (path == null) {
            throw new IllegalArgumentException();
        }
        int i = path.charAt(0) == '/' ? 1 : 0;
        ArrayList<String> segments = new ArrayList<String>();
        do {
            if ((j = path.indexOf(47, i)) == -1) {
                j = path.length();
            }
            segments.add(this.unescape(path.substring(i, j)));
        } while ((i = j + 1) < path.length());
        return segments;
    }

    private String unescape(String string) {
        try {
            return URLDecoder.decode(string, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private Map<String, String> decodeQuery(String query) {
        int j;
        if (query == null || query.isEmpty()) {
            return Collections.emptyMap();
        }
        int i = 0;
        HashMap<String, String> parameters = new HashMap<String, String>();
        do {
            String value;
            String key;
            String pair;
            int k;
            if ((j = query.indexOf(38, i)) == -1) {
                j = query.length();
            }
            if ((k = (pair = query.substring(i, j)).indexOf(61)) == -1) {
                key = this.unescape(pair);
                value = "true";
            } else {
                key = this.unescape(pair.substring(0, k));
                value = this.unescape(pair.substring(k + 1, pair.length()));
            }
            parameters.put(key, value);
        } while ((i = j + 1) < query.length());
        return parameters;
    }

    public void start() {
        this.server.start();
    }

    public void stop() {
        this.server.stop(0);
        this.modelController = null;
        if (this.serverTempDir.exists()) {
            for (File file : this.serverTempDir.listFiles()) {
                file.delete();
            }
            this.serverTempDir.delete();
        }
    }

    public static DomainHttpServer create(InetSocketAddress socket, int backlog, ModelController modelController, Executor executor, File serverTempDir) throws IOException {
        HttpServer server = HttpServer.create(socket, backlog);
        DomainHttpServer me = new DomainHttpServer(server, modelController, serverTempDir);
        server.createContext(DOMAIN_API_CONTEXT, me);
        server.createContext("/console", new ConsoleHandler());
        server.setExecutor(executor);
        return new DomainHttpServer(server, modelController, serverTempDir);
    }

    static enum GetOperation {
        RESOURCE("read-resource"),
        ATTRIBUTE("read-attribute"),
        RESOURCE_DESCRIPTION("read-resource-description"),
        OPERATION_DESCRIPTION("read-operation-description"),
        OPERATION_NAMES("read-operation-names");

        private String realOperation;

        private GetOperation(String realOperation) {
            this.realOperation = realOperation;
        }

        public String realOperation() {
            return this.realOperation;
        }
    }
}

