/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.jmx;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipInputStream;
import org.jboss.arquillian.api.DeploymentProvider;
import org.jboss.arquillian.protocol.jmx.RepositoryArchiveLocator;
import org.jboss.arquillian.protocol.jmx.ResourceCallbackHandler;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.arquillian.testenricher.jmx.SecurityActions;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.ArchiveBase;

class DeploymentProviderImpl
implements DeploymentProvider {
    private TestClass testClass;
    private ResourceCallbackHandler callbackHandler;

    DeploymentProviderImpl(TestClass testClass, ResourceCallbackHandler callbackHandler) {
        this.testClass = testClass;
        this.callbackHandler = callbackHandler;
    }

    public URL getArchiveURL(String artifactId) {
        return this.getArchiveURL(null, artifactId, null);
    }

    public URL getArchiveURL(String groupId, String artifactId, String version) {
        URL artifactURL = RepositoryArchiveLocator.getArtifactURL((String)groupId, (String)artifactId, (String)version);
        return artifactURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Archive<?> getClientDeployment(String name) {
        InputStream input = this.getClientDeploymentAsStream(name);
        ClassLoader ctxLoader = SecurityActions.getThreadContextClassLoader();
        try {
            SecurityActions.setThreadContextClassLoader(ArchiveBase.class.getClassLoader());
            JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)name);
            ZipImporter zipImporter = (ZipImporter)archive.as(ZipImporter.class);
            zipImporter.importZip(new ZipInputStream(input));
            JavaArchive javaArchive = archive;
            return javaArchive;
        }
        finally {
            SecurityActions.setThreadContextClassLoader(ctxLoader);
        }
    }

    public InputStream getClientDeploymentAsStream(String name) {
        try {
            byte[] bytes = this.callbackHandler.requestResource(this.testClass, name);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            return bais;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot obtain test archive: " + name, ex);
        }
    }
}

