/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public final class AnnotationInstance {
    private final DotName name;
    private final AnnotationTarget target;
    private final AnnotationValue[] values;

    AnnotationInstance(DotName name, AnnotationTarget target, AnnotationValue[] values) {
        this.name = name;
        this.target = target;
        this.values = values.length > 0 ? values : AnnotationValue.EMPTY_VALUE_ARRAY;
    }

    public DotName name() {
        return this.name;
    }

    public AnnotationTarget target() {
        return this.target;
    }

    public AnnotationValue value(final String name) {
        int result = Arrays.binarySearch(this.values, name, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((AnnotationValue)o1).name().compareTo(name);
            }
        });
        return result >= 0 ? this.values[result] : null;
    }

    public AnnotationValue value() {
        return this.value("value");
    }

    public List<AnnotationValue> values() {
        return Collections.unmodifiableList(Arrays.asList(this.values));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("@").append(this.name).append("(");
        for (int i = 0; i < this.values.length; ++i) {
            builder.append(this.values[i]);
            if (i >= this.values.length - 1) continue;
            builder.append(",");
        }
        builder.append(')');
        if (this.target != null) {
            builder.append(" on ").append(this.target);
        }
        return builder.toString();
    }
}

