/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class ConnectorRemove
implements ModelRemoveOperationHandler {
    static final OperationHandler INSTANCE = new ConnectorRemove();

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        final String name = address.getLastElement().getValue();
        ModelNode connector = context.getSubModel();
        ModelNode compensating = new ModelNode();
        compensating.get("address").set(operation.require("address"));
        compensating.get("operation").set("add");
        compensating.get("sasl").set(connector.get("sasl"));
        compensating.get("authentication-provider").set(connector.get("authentication-provider"));
        compensating.get("properties").set(connector.get("properties"));
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceName connectorServiceName = RemotingServices.connectorServiceName(name);
                    ServiceController controller = context.getServiceRegistry().getService(connectorServiceName);
                    if (controller != null) {
                        controller.setMode(ServiceController.Mode.REMOVE);
                    }
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensating);
    }
}

