/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.jboss.logging.Logger;
import org.jboss.osgi.jmx.BundleStateMBeanExt;
import org.jboss.osgi.jmx.ObjectNameFactory;
import org.jboss.osgi.jmx.internal.AbstractState;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.JmxConstants;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.service.packageadmin.PackageAdmin;

public class BundleStateExt
extends AbstractState
implements BundleStateMBeanExt {
    private static final Logger log = Logger.getLogger(BundleStateExt.class);

    public BundleStateExt(BundleContext context, MBeanServer mbeanServer) {
        super(context, mbeanServer);
    }

    @Override
    ObjectName getObjectName() {
        return ObjectNameFactory.create("jboss.osgi:service=jmx,type=BundleState");
    }

    @Override
    StandardMBean getStandardMBean() throws NotCompliantMBeanException {
        return new StandardMBean(this, BundleStateMBeanExt.class);
    }

    @Override
    public CompositeData getBundle(long bundleId) throws IOException {
        TabularData bundleList = this.listBundles();
        CompositeData compData = bundleList.get(new Object[]{bundleId});
        if (compData == null) {
            throw new IllegalArgumentException("No such bundle: " + bundleId);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("getBundle: " + bundleId + " => " + compData));
        }
        return compData;
    }

    @Override
    public String getDataFile(long bundleId, String filename) throws IOException {
        String result;
        BundleContext context = this.assertBundleContext(bundleId);
        File dataFile = context.getDataFile(filename);
        String string = result = dataFile != null ? dataFile.getCanonicalPath() : null;
        if (log.isTraceEnabled()) {
            log.trace((Object)("getDataFile [bundleId=" + bundleId + ",filename=" + filename + "] => " + result));
        }
        return result;
    }

    @Override
    public String getEntry(long bundleId, String path) throws IOException {
        String result;
        Bundle bundle = this.assertBundle(bundleId);
        URL entry = bundle.getEntry(path);
        String string = result = entry != null ? entry.toExternalForm() : null;
        if (log.isTraceEnabled()) {
            log.trace((Object)("getEntry [bundleId=" + bundleId + ",path=" + path + "] => " + result));
        }
        return result;
    }

    @Override
    public String getResource(long bundleId, String name) throws IOException {
        String result;
        Bundle bundle = this.assertBundle(bundleId);
        URL resource = bundle.getResource(name);
        String string = result = resource != null ? resource.toExternalForm() : null;
        if (log.isTraceEnabled()) {
            log.trace((Object)("getResource [bundleId=" + bundleId + ",name=" + name + "] => " + result));
        }
        return result;
    }

    @Override
    public TabularData getHeaders(long bundleId, String locale) throws IOException {
        Bundle bundle = this.assertBundle(bundleId);
        ArrayList<Header> result = new ArrayList<Header>();
        Dictionary bundleHeaders = bundle.getHeaders(locale);
        Enumeration keys = bundleHeaders.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            result.add(new Header(key, (String)bundleHeaders.get(key)));
        }
        TabularDataSupport headerTable = new TabularDataSupport(HEADERS_TYPE);
        for (Header header : result) {
            headerTable.put(header.toCompositeData());
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("getHeaders [bundleId=" + bundleId + ",locale=" + locale + "] => " + result));
        }
        return headerTable;
    }

    @Override
    public CompositeData getProperty(long bundleId, String key) throws IOException {
        CompositeDataSupport result = null;
        BundleContext bundleContext = this.assertBundleContext(bundleId);
        String value = bundleContext.getProperty(key);
        if (value != null) {
            String type = value.getClass().getSimpleName();
            HashMap<String, String> items = new HashMap<String, String>();
            items.put("Key", key);
            items.put("Value", value);
            items.put("Type", type);
            try {
                result = new CompositeDataSupport(JmxConstants.PROPERTY_TYPE, items);
            }
            catch (OpenDataException ex) {
                throw new JMRuntimeException("Failed to create CompositeData for property [" + key + ":" + value + "] - " + ex.getMessage());
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("getProperty [bundleId=" + bundleId + ",key=" + key + "] => " + result));
        }
        return result;
    }

    @Override
    public long loadClass(long bundleId, String name) throws ClassNotFoundException, IOException {
        long result;
        Bundle bundle = this.assertBundle(bundleId);
        Class clazz = bundle.loadClass(name);
        ServiceReference sref = this.context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin service = (PackageAdmin)this.context.getService(sref);
        Bundle exporter = service.getBundle(clazz);
        long l = result = exporter != null ? exporter.getBundleId() : 0L;
        if (log.isTraceEnabled()) {
            log.trace((Object)("loadClass [bundleId=" + bundleId + ",name=" + name + "] => " + result));
        }
        return result;
    }

    public String[] getExportedPackages(long bundleId) throws IOException {
        String[] result = this.getBundleStateMBean().getExportedPackages(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getExportedPackages [bundleId=" + bundleId + "] => " + result));
        }
        return result;
    }

    public long[] getFragments(long bundleId) throws IOException {
        long[] result = this.getBundleStateMBean().getFragments(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getFragments [bundleId=" + bundleId + "] => " + (result != null ? Arrays.asList(new long[][]{result}) : null)));
        }
        return result;
    }

    public TabularData getHeaders(long bundleId) throws IOException {
        TabularData result = this.getBundleStateMBean().getHeaders(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getHeaders [bundleId=" + bundleId + "] => " + result));
        }
        return result;
    }

    public long[] getHosts(long bundleId) throws IOException {
        long[] result = this.getBundleStateMBean().getHosts(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getHosts [bundleId=" + bundleId + "] => " + (result != null ? Arrays.asList(new long[][]{result}) : null)));
        }
        return result;
    }

    public String[] getImportedPackages(long bundleId) throws IOException {
        String[] result = this.getBundleStateMBean().getImportedPackages(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getImportedPackages [bundleId=" + bundleId + "] => " + (result != null ? Arrays.asList(result) : null)));
        }
        return result;
    }

    public long getLastModified(long bundleId) throws IOException {
        long result = this.getBundleStateMBean().getLastModified(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getLastModified [bundleId=" + bundleId + "] => " + new Date(result)));
        }
        return result;
    }

    public String getLocation(long bundleId) throws IOException {
        String result = this.getBundleStateMBean().getLocation(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getLocation [bundleId=" + bundleId + "] => " + result));
        }
        return result;
    }

    public long[] getRegisteredServices(long bundleId) throws IOException {
        long[] result = this.getBundleStateMBean().getRegisteredServices(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getRegisteredServices [bundleId=" + bundleId + "] => " + (result != null ? Arrays.asList(new long[][]{result}) : null)));
        }
        return result;
    }

    public long[] getRequiredBundles(long bundleId) throws IOException {
        long[] result = this.getBundleStateMBean().getRequiredBundles(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getRequiredBundles [bundleId=" + bundleId + "] => " + (result != null ? Arrays.asList(new long[][]{result}) : null)));
        }
        return result;
    }

    public long[] getRequiringBundles(long bundleId) throws IOException {
        long[] result = this.getBundleStateMBean().getRequiringBundles(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getRequiringBundles [bundleId=" + bundleId + "] => " + (result != null ? Arrays.asList(new long[][]{result}) : null)));
        }
        return result;
    }

    public long[] getServicesInUse(long bundleId) throws IOException {
        long[] result = this.getBundleStateMBean().getServicesInUse(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getServicesInUse [bundleId=" + bundleId + "] => " + (result != null ? Arrays.asList(new long[][]{result}) : null)));
        }
        return result;
    }

    public int getStartLevel(long bundleId) throws IOException {
        int result = this.getBundleStateMBean().getStartLevel(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getStartLevel [bundleId=" + bundleId + "] => " + result));
        }
        return result;
    }

    public String getState(long bundleId) throws IOException {
        String result = this.getBundleStateMBean().getState(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getState [bundleId=" + bundleId + "] => " + result));
        }
        return result;
    }

    public String getSymbolicName(long bundleId) throws IOException {
        String result = this.getBundleStateMBean().getSymbolicName(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getSymbolicName [bundleId=" + bundleId + "] => " + result));
        }
        return result;
    }

    public String getVersion(long bundleId) throws IOException {
        String result = this.getBundleStateMBean().getVersion(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getVersion [bundleId=" + bundleId + "] => " + result));
        }
        return result;
    }

    public boolean isFragment(long bundleId) throws IOException {
        boolean result = this.getBundleStateMBean().isFragment(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("isFragment [bundleId=" + bundleId + "] => " + result));
        }
        return result;
    }

    public boolean isPersistentlyStarted(long bundleId) throws IOException {
        boolean result = this.getBundleStateMBean().isPersistentlyStarted(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("isPersistentlyStarted [bundleId=" + bundleId + "] => " + result));
        }
        return result;
    }

    public boolean isRemovalPending(long bundleId) throws IOException {
        boolean result = this.getBundleStateMBean().isRemovalPending(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("isRemovalPending [bundleId=" + bundleId + "] => " + result));
        }
        return result;
    }

    public boolean isRequired(long bundleId) throws IOException {
        boolean result = this.getBundleStateMBean().isRequired(bundleId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("isRequired [bundleId=" + bundleId + "] => " + result));
        }
        return result;
    }

    public TabularData listBundles() throws IOException {
        TabularData result = this.getBundleStateMBean().listBundles();
        if (log.isTraceEnabled()) {
            log.trace((Object)("TabularData => " + result));
        }
        return result;
    }

    private Bundle assertBundle(long bundleId) {
        Bundle bundle = this.context.getBundle(bundleId);
        if (bundle == null) {
            throw new IllegalArgumentException("No such bundle: " + bundleId);
        }
        return bundle;
    }

    private BundleContext assertBundleContext(long bundleId) {
        Bundle bundle = this.assertBundle(bundleId);
        BundleContext bundleContext = bundle.getBundleContext();
        return bundleContext;
    }

    static class Header {
        private String key;
        private String value;

        String getKey() {
            return this.key;
        }

        String getValue() {
            return this.value;
        }

        private Header() {
        }

        Header(String key, String value) {
            this.key = key;
            this.value = value;
        }

        CompositeData toCompositeData() throws JMRuntimeException {
            CompositeDataSupport result = null;
            HashMap<String, String> items = new HashMap<String, String>();
            items.put("Key", this.key);
            items.put("Value", this.value);
            try {
                result = new CompositeDataSupport(BundleStateMBean.HEADER_TYPE, items);
            }
            catch (OpenDataException e) {
                throw new JMRuntimeException("Failed to create CompositeData for header [" + this.key + ":" + this.value + "] - " + e.getMessage());
            }
            return result;
        }

        static Header from(CompositeData compositeData) {
            if (compositeData == null) {
                throw new IllegalArgumentException("Argument compositeData cannot be null");
            }
            if (!compositeData.getCompositeType().equals(BundleStateMBean.HEADER_TYPE)) {
                throw new IllegalArgumentException("Invalid CompositeType [" + compositeData.getCompositeType() + "]");
            }
            Header header = new Header();
            header.key = (String)compositeData.get("Key");
            header.value = (String)compositeData.get("Value");
            return header;
        }
    }
}

