/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

abstract class AbstractBundleRevision {
    static final Logger log = Logger.getLogger(AbstractBundleRevision.class);
    private final int revision;
    private final AbstractBundleState bundleState;
    private final OSGiMetaData metadata;
    private XModule resolverModule;

    AbstractBundleRevision(AbstractBundleState bundleState, OSGiMetaData metadata, XModule resModule, int revision) throws BundleException {
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundleState");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Null metadata");
        }
        if (resModule == null) {
            throw new IllegalArgumentException("Null resModule");
        }
        this.bundleState = bundleState;
        this.metadata = metadata;
        this.revision = revision;
        this.resolverModule = resModule;
        resModule.addAttachment(AbstractBundleRevision.class, (Object)this);
    }

    int getRevisionId() {
        return this.revision;
    }

    XModule getResolverModule() {
        return this.resolverModule;
    }

    AbstractBundleState getBundleState() {
        return this.bundleState;
    }

    OSGiMetaData getOSGiMetaData() {
        return this.metadata;
    }

    Version getVersion() {
        return this.metadata.getBundleVersion();
    }

    abstract Class<?> loadClass(String var1) throws ClassNotFoundException;

    abstract URL getResource(String var1);

    abstract Enumeration<URL> getResources(String var1) throws IOException;

    abstract Enumeration<String> getEntryPaths(String var1);

    abstract URL getEntry(String var1);

    abstract Enumeration<URL> findEntries(String var1, String var2, boolean var3);

    abstract String getLocation();

    abstract URL getLocalizationEntry(String var1);

    ModuleIdentifier getModuleIdentifier() {
        try {
            ModuleManagerPlugin moduleManager = this.bundleState.getFrameworkState().getModuleManagerPlugin();
            return moduleManager.getModuleIdentifier(this.resolverModule);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot get module identifier for: " + this.resolverModule, ex);
        }
    }

    ModuleClassLoader getModuleClassLoader() {
        ModuleIdentifier identifier = this.getModuleIdentifier();
        try {
            ModuleManagerPlugin moduleManager = this.bundleState.getFrameworkState().getModuleManagerPlugin();
            Module module = moduleManager.loadModule(identifier);
            return module.getClassLoader();
        }
        catch (ModuleLoadException ex) {
            throw new IllegalStateException("Cannot load module: " + identifier);
        }
    }

    void refreshRevision(OSGiMetaData metadata) throws BundleException {
        this.resolverModule = this.createResolverModule(this.getBundleState(), metadata);
        this.refreshRevisionInternal(this.resolverModule);
    }

    abstract void refreshRevisionInternal(XModule var1);

    XModule createResolverModule(AbstractBundleState bundleState, OSGiMetaData metadata) throws BundleException {
        XModule resModule;
        String symbolicName = metadata.getBundleSymbolicName();
        Version version = metadata.getBundleVersion();
        int modulerev = this.getRevisionId();
        BundleManager bundleManager = bundleState.getBundleManager();
        for (AbstractBundleState aux : bundleManager.getBundles(symbolicName, version.toString())) {
            if (aux.getState() != 1) continue;
            resModule = aux.getResolverModule();
            int auxrev = resModule.getModuleId().getRevision();
            modulerev = Math.max(modulerev + 100, auxrev + 100);
        }
        ResolverPlugin resolverPlugin = bundleState.getFrameworkState().getResolverPlugin();
        XModuleBuilder builder = resolverPlugin.getModuleBuilder();
        resModule = builder.createModule(metadata, modulerev).getModule();
        resModule.addAttachment(AbstractBundleRevision.class, (Object)this);
        resModule.addAttachment(Bundle.class, (Object)bundleState);
        return resModule;
    }

    public String toString() {
        return "Revision[" + this.resolverModule.getModuleId() + "]";
    }
}

