/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

abstract class AbstractBundleService<T extends AbstractBundleState>
implements Service<T>,
Bundle {
    static final Logger log = Logger.getLogger(AbstractBundleService.class);
    private final T bundleState;

    AbstractBundleService(T bundleState) {
        this.bundleState = bundleState;
    }

    public void start(StartContext context) throws StartException {
        log.debugf("Starting: %s", (Object)context.getController().getName());
    }

    public void stop(StopContext context) {
        log.debugf("Stopping: %s", (Object)context.getController().getName());
    }

    public T getValue() {
        return this.bundleState;
    }

    T getBundleState() {
        return this.bundleState;
    }

    BundleManager getBundleManager() {
        return ((AbstractBundleState)this.bundleState).getBundleManager();
    }

    FrameworkState getFrameworkState() {
        return ((AbstractBundleState)this.bundleState).getFrameworkState();
    }

    public int getState() {
        return ((AbstractBundleState)this.bundleState).getState();
    }

    public long getBundleId() {
        return ((AbstractBundleState)this.bundleState).getBundleId();
    }

    public String getLocation() {
        return this.bundleState.getLocation();
    }

    public ServiceReference[] getRegisteredServices() {
        return ((AbstractBundleState)this.bundleState).getRegisteredServices();
    }

    public ServiceReference[] getServicesInUse() {
        return ((AbstractBundleState)this.bundleState).getServicesInUse();
    }

    public boolean hasPermission(Object permission) {
        return ((AbstractBundleState)this.bundleState).hasPermission(permission);
    }

    public URL getResource(String name) {
        return ((AbstractBundleState)this.bundleState).getResource(name);
    }

    public Dictionary<String, String> getHeaders() {
        return ((AbstractBundleState)this.bundleState).getHeaders();
    }

    public Dictionary<String, String> getHeaders(String locale) {
        return ((AbstractBundleState)this.bundleState).getHeaders(locale);
    }

    public String getSymbolicName() {
        return ((AbstractBundleState)this.bundleState).getSymbolicName();
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return ((AbstractBundleState)this.bundleState).loadClass(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return ((AbstractBundleState)this.bundleState).getResources(name);
    }

    public Enumeration<String> getEntryPaths(String path) {
        return ((AbstractBundleState)this.bundleState).getEntryPaths(path);
    }

    public URL getEntry(String path) {
        return ((AbstractBundleState)this.bundleState).getEntry(path);
    }

    public long getLastModified() {
        return ((AbstractBundleState)this.bundleState).getLastModified();
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        return ((AbstractBundleState)this.bundleState).findEntries(path, filePattern, recurse);
    }

    public BundleContext getBundleContext() {
        return ((AbstractBundleState)this.bundleState).getBundleContext();
    }

    public Map getSignerCertificates(int signersType) {
        return ((AbstractBundleState)this.bundleState).getSignerCertificates(signersType);
    }

    public Version getVersion() {
        return ((AbstractBundleState)this.bundleState).getVersion();
    }

    public void start(int options) throws BundleException {
        throw new UnsupportedOperationException("Not supported on the service object");
    }

    public void start() throws BundleException {
        throw new UnsupportedOperationException("Not supported on the service object");
    }

    public void stop(int options) throws BundleException {
        throw new UnsupportedOperationException("Not supported on the service object");
    }

    public void stop() throws BundleException {
        throw new UnsupportedOperationException("Not supported on the service object");
    }

    public void update(InputStream input) throws BundleException {
        throw new UnsupportedOperationException("Not supported on the service object");
    }

    public void update() throws BundleException {
        throw new UnsupportedOperationException("Not supported on the service object");
    }

    public void uninstall() throws BundleException {
        throw new UnsupportedOperationException("Not supported on the service object");
    }
}

