/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.framework.internal.AbstractBundleContext;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.BundleProxy;
import org.jboss.osgi.framework.internal.BundleStorageState;
import org.jboss.osgi.framework.internal.BundleWrapper;
import org.jboss.osgi.framework.internal.CoreServices;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.LifecycleInterceptorPlugin;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.framework.internal.ServiceState;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.metadata.CaseInsensitiveDictionary;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.spi.NotImplementedException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

abstract class AbstractBundleState
implements Bundle {
    static final Logger log = Logger.getLogger(AbstractBundleState.class);
    private final long bundleId;
    private final String symbolicName;
    private final FrameworkState frameworkState;
    private final AtomicInteger bundleState = new AtomicInteger(1);
    private final CopyOnWriteArrayList<ServiceState> registeredServices = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<ServiceState, AtomicInteger> usedServices = new ConcurrentHashMap();
    private AbstractBundleContext bundleContext;
    private Bundle bundleProxy;

    AbstractBundleState(FrameworkState frameworkState, long bundleId, String symbolicName) {
        if (frameworkState == null) {
            throw new IllegalStateException("Null frameworkState");
        }
        if (symbolicName != null && symbolicName.indexOf(59) > 0) {
            symbolicName = symbolicName.substring(0, symbolicName.indexOf(59));
        }
        this.bundleId = bundleId;
        this.symbolicName = symbolicName;
        this.frameworkState = frameworkState;
    }

    FrameworkState getFrameworkState() {
        return this.frameworkState;
    }

    BundleManager getBundleManager() {
        return this.frameworkState.getBundleManager();
    }

    SystemBundleState getSystemBundle() {
        return this.frameworkState.getSystemBundle();
    }

    CoreServices getCoreServices() {
        return this.frameworkState.getCoreServices();
    }

    public int getState() {
        return this.bundleState.get();
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    Bundle getBundleProxy() {
        if (this.bundleProxy == null) {
            this.bundleProxy = this.createBundleProxy();
        }
        return this.bundleProxy;
    }

    abstract Bundle createBundleProxy();

    abstract AbstractBundleContext createContextInternal();

    abstract AbstractBundleRevision getCurrentRevision();

    abstract AbstractBundleRevision getRevisionById(int var1);

    abstract ServiceName getServiceName();

    abstract boolean isFragment();

    abstract boolean isSingleton();

    abstract BundleStorageState getBundleStorageState();

    ModuleIdentifier getModuleIdentifier() {
        return this.getCurrentRevision().getModuleIdentifier();
    }

    void changeState(int state) {
        int bundleEvent;
        switch (state) {
            case 8: {
                bundleEvent = 128;
                break;
            }
            case 32: {
                bundleEvent = 2;
                break;
            }
            case 16: {
                bundleEvent = 256;
                break;
            }
            case 1: {
                bundleEvent = 16;
                break;
            }
            case 2: {
                bundleEvent = 1;
                break;
            }
            case 4: {
                bundleEvent = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown bundle state: " + state);
            }
        }
        this.changeState(state, bundleEvent);
    }

    void changeState(int state, int eventType) {
        boolean frameworkActive = this.getBundleManager().isFrameworkActive();
        if (frameworkActive && this.bundleId > 0L) {
            LifecycleInterceptorPlugin plugin = this.getCoreServices().getLifecycleInterceptorPlugin();
            plugin.handleStateChange(state, this);
        }
        this.bundleState.set(state);
        if (frameworkActive && eventType != 0) {
            FrameworkEventsPlugin eventsPlugin = this.getFrameworkState().getFrameworkEventsPlugin();
            eventsPlugin.fireBundleEvent(this, eventType);
        }
    }

    void addRegisteredService(ServiceState serviceState) {
        log.tracef("Add registered service %s to: %s", (Object)serviceState, (Object)this);
        this.registeredServices.add(serviceState);
    }

    void removeRegisteredService(ServiceState serviceState) {
        log.tracef("Remove registered service %s from: %s", (Object)serviceState, (Object)this);
        this.registeredServices.remove(serviceState);
    }

    public ServiceReference[] getRegisteredServices() {
        this.assertNotUninstalled();
        List<ServiceState> rs = this.getRegisteredServicesInternal();
        if (rs.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> srefs = new ArrayList<ServiceReference>();
        for (ServiceState serviceState : rs) {
            srefs.add(serviceState.getReference());
        }
        return srefs.toArray(new ServiceReference[srefs.size()]);
    }

    List<ServiceState> getRegisteredServicesInternal() {
        return Collections.unmodifiableList(this.registeredServices);
    }

    public ServiceReference[] getServicesInUse() {
        this.assertNotUninstalled();
        Set<ServiceState> servicesInUse = this.getServicesInUseInternal();
        if (servicesInUse.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> srefs = new ArrayList<ServiceReference>();
        for (ServiceState serviceState : servicesInUse) {
            srefs.add(serviceState.getReference());
        }
        return srefs.toArray(new ServiceReference[srefs.size()]);
    }

    Set<ServiceState> getServicesInUseInternal() {
        return Collections.unmodifiableSet(this.usedServices.keySet());
    }

    void addServiceInUse(ServiceState serviceState) {
        log.tracef("Add service in use %s to: %s", (Object)serviceState, (Object)this);
        this.usedServices.putIfAbsent(serviceState, new AtomicInteger());
        AtomicInteger count = this.usedServices.get(serviceState);
        count.incrementAndGet();
    }

    int removeServiceInUse(ServiceState serviceState) {
        log.tracef("Remove service in use %s from: %s", (Object)serviceState, (Object)this);
        AtomicInteger count = this.usedServices.get(serviceState);
        if (count == null) {
            return -1;
        }
        int countVal = count.decrementAndGet();
        if (countVal == 0) {
            this.usedServices.remove(serviceState);
        }
        return countVal;
    }

    public boolean hasPermission(Object permission) {
        this.assertNotUninstalled();
        if (permission == null || !(permission instanceof Permission)) {
            return false;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return true;
        }
        return true;
    }

    public URL getResource(String name) {
        return this.getCurrentRevision().getResource(name);
    }

    public Dictionary<String, String> getHeaders() {
        return this.getHeaders(null);
    }

    public Dictionary<String, String> getHeaders(String locale) {
        URL entryURL;
        String baseName;
        Dictionary rawHeaders = this.getOSGiMetaData().getHeaders();
        if ("".equals(locale)) {
            return rawHeaders;
        }
        if (locale == null) {
            locale = Locale.getDefault().toString();
        }
        if ((baseName = (String)rawHeaders.get("Bundle-Localization")) == null) {
            baseName = "OSGI-INF/l10n/bundle";
        }
        if ((entryURL = this.getLocalizationEntry(baseName, locale)) == null) {
            String defaultLocale = Locale.getDefault().toString();
            entryURL = this.getLocalizationEntry(baseName, defaultLocale);
        }
        PropertyResourceBundle resBundle = null;
        if (entryURL != null) {
            try {
                resBundle = new PropertyResourceBundle(entryURL.openStream());
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot read resouce bundle: " + entryURL, ex);
            }
        }
        Hashtable<String, String> locHeaders = new Hashtable<String, String>();
        Enumeration e = rawHeaders.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)rawHeaders.get(key);
            if (value.startsWith("%")) {
                value = value.substring(1);
            }
            if (resBundle != null) {
                try {
                    value = resBundle.getString(value);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
            }
            ((Dictionary)locHeaders).put(key, value);
        }
        return new CaseInsensitiveDictionary(locHeaders);
    }

    OSGiMetaData getOSGiMetaData() {
        return this.getCurrentRevision().getOSGiMetaData();
    }

    XModule getResolverModule() {
        return this.getCurrentRevision().getResolverModule();
    }

    boolean isResolved() {
        return this.getResolverModule().isResolved();
    }

    boolean isUninstalled() {
        return this.getState() == 1;
    }

    private URL getLocalizationEntry(String baseName, String locale) {
        String entryPath = baseName + "_" + locale + ".properties";
        URL entryURL = this.getLocalizationEntry(entryPath);
        while (entryURL == null && !entryPath.equals(baseName + ".properties")) {
            int lastIndex = locale.lastIndexOf(95);
            if (lastIndex > 0) {
                locale = locale.substring(0, lastIndex);
                entryPath = baseName + "_" + locale + ".properties";
            } else {
                entryPath = baseName + ".properties";
            }
            entryURL = this.getLocalizationEntry(entryPath);
        }
        return entryURL;
    }

    private URL getLocalizationEntry(String entryPath) {
        return this.getCurrentRevision().getLocalizationEntry(entryPath);
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.getCurrentRevision().loadClass(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.getCurrentRevision().getResources(name);
    }

    public Enumeration<String> getEntryPaths(String path) {
        return this.getCurrentRevision().getEntryPaths(path);
    }

    public URL getEntry(String path) {
        return this.getCurrentRevision().getEntry(path);
    }

    public long getLastModified() {
        return this.getBundleStorageState().getLastModified();
    }

    void updateLastModified() {
        this.getBundleStorageState().updateLastModified();
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        return this.getCurrentRevision().findEntries(path, filePattern, recurse);
    }

    AbstractBundleContext getBundleContextInternal() {
        return this.bundleContext;
    }

    AbstractBundleContext createBundleContext() {
        if (this.bundleContext != null) {
            throw new IllegalStateException("BundleContext already available");
        }
        this.bundleContext = this.createContextInternal();
        return this.bundleContext;
    }

    void destroyBundleContext() {
        if (this.bundleContext != null) {
            this.bundleContext.destroy();
            this.bundleContext = null;
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Map getSignerCertificates(int signersType) {
        throw new NotImplementedException();
    }

    public Version getVersion() {
        return this.getCurrentRevision().getVersion();
    }

    public void start() throws BundleException {
        this.assertNotUninstalled();
        this.startInternal(0);
    }

    public void start(int options) throws BundleException {
        this.assertNotUninstalled();
        this.startInternal(options);
    }

    abstract void startInternal(int var1) throws BundleException;

    public void stop() throws BundleException {
        this.assertNotUninstalled();
        this.stopInternal(0);
    }

    public void stop(int options) throws BundleException {
        this.assertNotUninstalled();
        this.stopInternal(options);
    }

    abstract void stopInternal(int var1) throws BundleException;

    public void update() throws BundleException {
        this.assertNotUninstalled();
        this.updateInternal(null);
        log.infof("Bundle updated: %s", (Object)this);
        this.updateLastModified();
    }

    public void update(InputStream input) throws BundleException {
        this.assertNotUninstalled();
        this.updateInternal(input);
        log.infof("Bundle updated: %s", (Object)this);
        this.updateLastModified();
    }

    abstract void updateInternal(InputStream var1) throws BundleException;

    public void uninstall() throws BundleException {
        this.assertNotUninstalled();
        this.uninstallInternal();
    }

    abstract void uninstallInternal() throws BundleException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ensureResolved(boolean fireEvent) {
        AbstractBundleState abstractBundleState = this;
        synchronized (abstractBundleState) {
            XModule resModule = this.getResolverModule();
            if (resModule.isResolved()) {
                return true;
            }
            try {
                ResolverPlugin resolverPlugin = this.getFrameworkState().getResolverPlugin();
                resolverPlugin.resolve(resModule);
                return true;
            }
            catch (BundleException ex) {
                if (fireEvent) {
                    FrameworkEventsPlugin eventsPlugin = this.getFrameworkState().getFrameworkEventsPlugin();
                    eventsPlugin.fireFrameworkEvent(this, 2, ex);
                }
                return false;
            }
        }
    }

    abstract List<XModule> getAllResolverModules();

    void assertNotUninstalled() {
        if (this.getState() == 1) {
            throw new IllegalStateException("Bundle uninstalled: " + this);
        }
    }

    static AbstractBundleState assertBundleState(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        if (bundle instanceof BundleProxy) {
            bundle = ((BundleProxy)bundle).getBundleState();
        }
        if (bundle instanceof BundleWrapper) {
            bundle = ((BundleWrapper)((Object)bundle)).getBundleState();
        }
        if (!(bundle instanceof AbstractBundleState)) {
            throw new IllegalArgumentException("Not a BundleState: " + bundle);
        }
        return (AbstractBundleState)bundle;
    }

    String getCanonicalName() {
        return this.getSymbolicName() + ":" + this.getVersion();
    }

    public int hashCode() {
        return (int)this.getBundleId() * 51;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractBundleState)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AbstractBundleState other = (AbstractBundleState)obj;
        return this.getBundleId() == other.getBundleId();
    }

    public String toString() {
        return this.getCanonicalName();
    }
}

