/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.framework.internal.AbstractPluginService;

abstract class AbstractExecutorService<T>
extends AbstractPluginService<T> {
    private ExecutorService executorService;
    private AtomicInteger threadCount = new AtomicInteger();
    private String typeName;

    AbstractExecutorService(String executorType) {
        this.typeName = executorType;
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        this.executorService = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable run) {
                Thread thread = new Thread(run);
                thread.setName(String.format("OSGi " + AbstractExecutorService.this.typeName + " Thread-%d", AbstractExecutorService.this.threadCount.incrementAndGet()));
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.executorService.shutdown();
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

