/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.FutureServiceValue;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

abstract class BundleProxy<T extends AbstractBundleState>
implements Bundle {
    static final Logger log = Logger.getLogger(BundleProxy.class);
    private final ServiceContainer serviceContainer;
    private final ServiceName serviceName;
    private String cachedObjectName;
    private long bundleId;
    private T bundleState;

    BundleProxy(T bundleState) {
        this.serviceContainer = ((AbstractBundleState)bundleState).getBundleManager().getServiceContainer();
        this.serviceName = ((AbstractBundleState)bundleState).getServiceName();
        this.cachedObjectName = ((AbstractBundleState)bundleState).toString();
        this.bundleId = ((AbstractBundleState)bundleState).getBundleId();
    }

    T getBundleState() {
        return this.awaitBundleServiceActive();
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public int getState() {
        return ((AbstractBundleState)this.awaitBundleServiceActive()).getState();
    }

    public void start(int options) throws BundleException {
        ((AbstractBundleState)this.awaitBundleServiceActive()).start(options);
    }

    public void start() throws BundleException {
        ((AbstractBundleState)this.awaitBundleServiceActive()).start();
    }

    public void stop(int options) throws BundleException {
        ((AbstractBundleState)this.awaitBundleServiceActive()).stop(options);
    }

    public void stop() throws BundleException {
        ((AbstractBundleState)this.awaitBundleServiceActive()).stop();
    }

    public void update(InputStream input) throws BundleException {
        ((AbstractBundleState)this.awaitBundleServiceActive()).update(input);
    }

    public void update() throws BundleException {
        ((AbstractBundleState)this.awaitBundleServiceActive()).update();
    }

    public void uninstall() throws BundleException {
        ((AbstractBundleState)this.awaitBundleServiceActive()).uninstall();
    }

    public Dictionary<String, String> getHeaders() {
        return ((AbstractBundleState)this.awaitBundleServiceActive()).getHeaders();
    }

    public String getLocation() {
        return this.awaitBundleServiceActive().getLocation();
    }

    public ServiceReference[] getRegisteredServices() {
        return ((AbstractBundleState)this.awaitBundleServiceActive()).getRegisteredServices();
    }

    public ServiceReference[] getServicesInUse() {
        return ((AbstractBundleState)this.awaitBundleServiceActive()).getServicesInUse();
    }

    public boolean hasPermission(Object permission) {
        return ((AbstractBundleState)this.awaitBundleServiceActive()).hasPermission(permission);
    }

    public URL getResource(String name) {
        return ((AbstractBundleState)this.awaitBundleServiceActive()).getResource(name);
    }

    public Dictionary<String, String> getHeaders(String locale) {
        return ((AbstractBundleState)this.awaitBundleServiceActive()).getHeaders(locale);
    }

    public String getSymbolicName() {
        return ((AbstractBundleState)this.awaitBundleServiceActive()).getSymbolicName();
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return ((AbstractBundleState)this.awaitBundleServiceActive()).loadClass(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return ((AbstractBundleState)this.awaitBundleServiceActive()).getResources(name);
    }

    public Enumeration<String> getEntryPaths(String path) {
        return ((AbstractBundleState)this.awaitBundleServiceActive()).getEntryPaths(path);
    }

    public URL getEntry(String path) {
        return ((AbstractBundleState)this.awaitBundleServiceActive()).getEntry(path);
    }

    public long getLastModified() {
        return ((AbstractBundleState)this.awaitBundleServiceActive()).getLastModified();
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        return ((AbstractBundleState)this.awaitBundleServiceActive()).findEntries(path, filePattern, recurse);
    }

    public BundleContext getBundleContext() {
        return ((AbstractBundleState)this.awaitBundleServiceActive()).getBundleContext();
    }

    public Map getSignerCertificates(int signersType) {
        return ((AbstractBundleState)this.awaitBundleServiceActive()).getSignerCertificates(signersType);
    }

    public Version getVersion() {
        return ((AbstractBundleState)this.awaitBundleServiceActive()).getVersion();
    }

    private T awaitBundleServiceActive() {
        if (this.bundleState == null) {
            ServiceController controller = this.serviceContainer.getRequiredService(this.serviceName);
            controller.addListener((ServiceListener)new AbstractServiceListener<T>(){

                public void serviceStopped(ServiceController<? extends T> controller) {
                    controller.removeListener((ServiceListener)this);
                }
            });
            controller.setMode(ServiceController.Mode.ACTIVE);
            FutureServiceValue future = new FutureServiceValue(controller);
            try {
                this.bundleState = (AbstractBundleState)future.get(2000L, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause();
                throw new IllegalStateException("Cannot starting bundle service: " + this.serviceName, cause);
            }
            catch (TimeoutException e) {
                throw new IllegalStateException("Timeout starting bundle service: " + this.serviceName);
            }
        }
        return this.bundleState;
    }

    public String toString() {
        return this.cachedObjectName;
    }
}

