/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.BundleInstallHandler;
import org.jboss.osgi.framework.ServiceNames;
import org.jboss.osgi.framework.SystemServicesProvider;
import org.jboss.osgi.framework.internal.FrameworkService;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.LifecycleInterceptorPlugin;
import org.jboss.osgi.framework.internal.PackageAdminPlugin;
import org.jboss.osgi.framework.internal.StartLevelPlugin;
import org.osgi.framework.BundleContext;

public final class CoreServices
extends AbstractService<CoreServices> {
    static final Logger log = Logger.getLogger(CoreServices.class);
    private final InjectedValue<FrameworkService> injectedFramework = new InjectedValue();
    private final InjectedValue<BundleInstallHandler> injectedInstallProvider = new InjectedValue();
    private final InjectedValue<LifecycleInterceptorPlugin> injectedLifecycleInterceptor = new InjectedValue();
    private final InjectedValue<PackageAdminPlugin> injectedPackageAdmin = new InjectedValue();
    private final InjectedValue<StartLevelPlugin> injectedStartLevel = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<SystemServicesProvider> injectedServicesProvider = new InjectedValue();

    static void addService(ServiceTarget serviceTarget) {
        CoreServices service = new CoreServices();
        ServiceBuilder builder = serviceTarget.addService(InternalServices.CORE_SERVICES, (Service)service);
        builder.addDependency(ServiceNames.BUNDLE_INSTALL_HANDLER, BundleInstallHandler.class, service.injectedInstallProvider);
        builder.addDependency(ServiceNames.FRAMEWORK_CREATE, FrameworkService.class, service.injectedFramework);
        builder.addDependency(InternalServices.LIFECYCLE_INTERCEPTOR_PLUGIN, LifecycleInterceptorPlugin.class, service.injectedLifecycleInterceptor);
        builder.addDependency(ServiceNames.PACKAGE_ADMIN, PackageAdminPlugin.class, service.injectedPackageAdmin);
        builder.addDependency(ServiceNames.START_LEVEL, StartLevelPlugin.class, service.injectedStartLevel);
        builder.addDependency(ServiceNames.SYSTEM_CONTEXT, BundleContext.class, service.injectedSystemContext);
        builder.addDependency(ServiceNames.SYSTEM_SERVICES_PROVIDER, SystemServicesProvider.class, service.injectedServicesProvider);
        builder.addDependencies(new ServiceName[]{InternalServices.URL_HANDLER_PLUGIN, InternalServices.WEBXML_VERIFIER_PLUGIN});
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private CoreServices() {
    }

    public void start(StartContext context) throws StartException {
        log.debugf("Starting: %s", (Object)context.getController().getName());
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        SystemServicesProvider servicesProvider = (SystemServicesProvider)this.injectedServicesProvider.getValue();
        servicesProvider.registerSystemServices(systemContext);
        this.getFrameworkState().injectedCoreServices.inject((Object)this);
    }

    public void stop(StopContext context) {
        log.debugf("Stopping: %s", (Object)context.getController().getName());
        this.getFrameworkState().injectedCoreServices.uninject();
    }

    public CoreServices getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    BundleInstallHandler getInstallHandler() {
        return (BundleInstallHandler)this.injectedInstallProvider.getValue();
    }

    FrameworkState getFrameworkState() {
        return ((FrameworkService)this.injectedFramework.getValue()).getFrameworkState();
    }

    LifecycleInterceptorPlugin getLifecycleInterceptorPlugin() {
        return (LifecycleInterceptorPlugin)((Object)this.injectedLifecycleInterceptor.getValue());
    }

    PackageAdminPlugin getPackageAdmin() {
        return (PackageAdminPlugin)((Object)this.injectedPackageAdmin.getValue());
    }

    StartLevelPlugin getStartLevelPlugin() {
        return (StartLevelPlugin)((Object)this.injectedStartLevel.getValue());
    }
}

