/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleInstallHandler;
import org.jboss.osgi.framework.ServiceNames;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleManager;
import org.osgi.framework.BundleException;

final class DefaultBundleInstallHandler
extends AbstractPluginService<BundleInstallHandler>
implements BundleInstallHandler {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();

    static void addService(ServiceTarget serviceTarget) {
        DefaultBundleInstallHandler service = new DefaultBundleInstallHandler();
        ServiceBuilder builder = serviceTarget.addService(ServiceNames.BUNDLE_INSTALL_HANDLER, (Service)service);
        builder.addDependency(ServiceNames.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
        builder.addDependency(ServiceNames.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private DefaultBundleInstallHandler() {
    }

    public BundleInstallHandler getValue() {
        return this;
    }

    @Override
    public void installBundle(ServiceTarget serviceTarget, Deployment dep) throws BundleException {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        bundleManager.installBundle(serviceTarget, dep);
    }

    @Override
    public void uninstallBundle(Deployment dep) {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        bundleManager.uninstallBundle(dep);
    }
}

