/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.ServiceNames;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkService;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.framework.internal.StartLevelPlugin;
import org.osgi.framework.BundleException;

public final class FrameworkActive
extends FrameworkService {
    static final Logger log = Logger.getLogger(FrameworkActive.class);
    private final InjectedValue<FrameworkService> injectedFramework = new InjectedValue();

    static void addService(ServiceTarget serviceTarget, ServiceController.Mode initialMode) {
        FrameworkActive service = new FrameworkActive();
        ServiceBuilder builder = serviceTarget.addService(ServiceNames.FRAMEWORK_ACTIVE, (Service)service);
        builder.addDependency(ServiceNames.FRAMEWORK_INIT, FrameworkService.class, service.injectedFramework);
        builder.addDependencies(new ServiceName[]{ServiceNames.AUTOINSTALL_BUNDLES, ServiceNames.AUTOINSTALL_BUNDLES_COMPLETE});
        builder.setInitialMode(initialMode);
        builder.install();
    }

    private FrameworkActive() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        try {
            ResolverPlugin resolverPlugin = this.getFrameworkState().getResolverPlugin();
            resolverPlugin.resolve(this.getSystemBundle().getResolverModule());
            this.getSystemBundle().changeState(32);
            StartLevelPlugin startLevelPlugin = this.getFrameworkState().getCoreServices().getStartLevelPlugin();
            startLevelPlugin.increaseStartLevel(this.getBeginningStartLevel());
            FrameworkEventsPlugin eventsPlugin = this.getFrameworkState().getFrameworkEventsPlugin();
            eventsPlugin.fireFrameworkEvent(this.getSystemBundle(), 1, null);
            log.infof("OSGi Framework started", new Object[0]);
        }
        catch (BundleException ex) {
            throw new StartException((Throwable)ex);
        }
    }

    @Override
    FrameworkState getFrameworkState() {
        return ((FrameworkService)this.injectedFramework.getValue()).getFrameworkState();
    }

    private int getBeginningStartLevel() {
        String beginning = (String)this.getBundleManager().getProperty("org.osgi.framework.startlevel.beginning");
        if (beginning == null) {
            return 1;
        }
        try {
            return Integer.parseInt(beginning);
        }
        catch (NumberFormatException nfe) {
            log.errorf("Could not set beginning start level to: %s", (Object)beginning);
            return 1;
        }
    }
}

