/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.ServiceNames;
import org.jboss.osgi.framework.internal.FrameworkService;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.InternalServices;

public final class FrameworkInit
extends FrameworkService {
    static final Logger log = Logger.getLogger(FrameworkInit.class);
    private final InjectedValue<FrameworkService> injectedFramework = new InjectedValue();

    static void addService(ServiceTarget serviceTarget) {
        FrameworkInit service = new FrameworkInit();
        ServiceBuilder builder = serviceTarget.addService(ServiceNames.FRAMEWORK_INIT, (Service)service);
        builder.addDependency(ServiceNames.FRAMEWORK_CREATE, FrameworkService.class, service.injectedFramework);
        builder.addDependency(InternalServices.CORE_SERVICES);
        builder.addDependency(InternalServices.PERSISTENT_BUNDLES_INSTALLER);
        builder.addDependency(InternalServices.PERSISTENT_BUNDLES_INSTALLER_COMPLETE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private FrameworkInit() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        log.debugf("OSGi Framework initilized", new Object[0]);
    }

    @Override
    FrameworkState getFrameworkState() {
        return ((FrameworkService)this.injectedFramework.getValue()).getFrameworkState();
    }
}

