/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.osgi.framework.ServiceNames;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.CoreServices;
import org.jboss.osgi.framework.internal.FrameworkBuilder;
import org.jboss.osgi.framework.internal.FrameworkService;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.FutureServiceValue;
import org.jboss.osgi.framework.internal.StartLevelPlugin;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.spi.NotImplementedException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;

final class FrameworkProxy
implements Framework {
    static final Logger log = Logger.getLogger(FrameworkProxy.class);
    private final FrameworkBuilder frameworkBuilder;
    private ServiceContainer serviceContainer;
    private boolean shutdownContainer;
    private int frameworkBundleState;
    private boolean serviceStopped;
    private boolean firstInit;
    private int stoppedEvent;
    private FrameworkState frameworkInit;
    private FrameworkState activeFramework;

    FrameworkProxy(FrameworkBuilder frameworkBuilder) {
        this.frameworkBuilder = frameworkBuilder;
        this.stoppedEvent = 64;
        this.frameworkBundleState = 2;
        this.firstInit = true;
    }

    public long getBundleId() {
        return 0L;
    }

    public String getSymbolicName() {
        return "system.bundle";
    }

    public String getLocation() {
        return "System Bundle";
    }

    public Version getVersion() {
        return Version.emptyVersion;
    }

    public void init() throws BundleException {
        int state = this.getState();
        if (state == 8 || state == 32 || state == 16) {
            return;
        }
        try {
            ServiceTarget serviceTarget;
            this.serviceStopped = false;
            this.serviceContainer = this.frameworkBuilder.getServiceContainer();
            if (this.serviceContainer == null) {
                this.serviceContainer = ServiceContainer.Factory.create();
                this.shutdownContainer = true;
            }
            if ((serviceTarget = this.frameworkBuilder.getServiceTarget()) == null) {
                serviceTarget = this.serviceContainer.subTarget();
            }
            this.frameworkBuilder.createFrameworkServicesInternal(serviceTarget, ServiceController.Mode.ON_DEMAND, this.firstInit);
            this.awaitFrameworkInit();
            this.firstInit = false;
        }
        catch (IllegalStateException ex) {
            throw new BundleException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void start() throws BundleException {
        this.start(0);
    }

    public void start(int options) throws BundleException {
        if (this.getState() != 8) {
            this.init();
        }
        try {
            FrameworkState frameworkState = this.awaitFrameworkInit();
            frameworkState.setStartStopOptions(options);
            this.awaitActiveFramework();
        }
        catch (IllegalStateException ex) {
            throw new BundleException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    public void stop(int options) throws BundleException {
        this.stopInternal(false);
    }

    private void stopInternal(boolean stopForUpdate) {
        int state = this.getState();
        if (state != 8 && state != 32) {
            return;
        }
        FrameworkState frameworkState = this.awaitFrameworkInit();
        CoreServices coreServices = frameworkState.getCoreServices();
        SystemBundleState systemBundle = frameworkState.getSystemBundle();
        this.stoppedEvent = stopForUpdate ? 128 : 64;
        systemBundle.changeState(16);
        StartLevelPlugin startLevel = coreServices.getStartLevelPlugin();
        if (startLevel != null) {
            startLevel.decreaseStartLevel(0);
        } else {
            BundleManager bundleManager = systemBundle.getBundleManager();
            for (AbstractBundleState bundleState : bundleManager.getBundles()) {
                if (bundleState.getBundleId() == 0L) continue;
                try {
                    bundleState.stop(1);
                }
                catch (Exception ex) {
                    bundleManager.fireFrameworkError(bundleState, "stopping bundle", ex);
                }
            }
        }
        if (this.shutdownContainer) {
            this.serviceContainer.shutdown();
        } else {
            ServiceController controller = this.serviceContainer.getRequiredService(ServiceNames.BUNDLE_MANAGER);
            controller.setMode(ServiceController.Mode.REMOVE);
        }
    }

    public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        if (this.shutdownContainer) {
            this.serviceContainer.awaitTermination(timeout, TimeUnit.MILLISECONDS);
            if (!this.serviceContainer.isShutdownComplete()) {
                return new FrameworkEvent(512, (Bundle)this, null);
            }
        } else {
            final CountDownLatch latch = new CountDownLatch(1);
            ServiceController controller = this.serviceContainer.getRequiredService(ServiceNames.BUNDLE_MANAGER);
            controller.addListener((ServiceListener)new AbstractServiceListener<BundleManager>(){

                public void serviceRemoved(ServiceController<? extends BundleManager> controller) {
                    controller.removeListener((ServiceListener)this);
                    latch.countDown();
                }
            });
            controller.setMode(ServiceController.Mode.REMOVE);
            if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
                return new FrameworkEvent(512, (Bundle)this, null);
            }
        }
        return new FrameworkEvent(this.stoppedEvent, (Bundle)this, null);
    }

    public void update(InputStream input) throws BundleException {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.update();
    }

    public void update() {
        int state = this.getState();
        if (state != 8 && state != 32) {
            return;
        }
        final int targetState = this.getState();
        Runnable cmd = new Runnable(){

            @Override
            public void run() {
                try {
                    FrameworkProxy.this.stopInternal(true);
                    if (targetState == 8) {
                        FrameworkProxy.this.init();
                    }
                    if (targetState == 32) {
                        FrameworkProxy.this.start();
                    }
                }
                catch (Exception ex) {
                    log.errorf((Throwable)ex, "Error stopping framework", new Object[0]);
                }
            }
        };
        new Thread(cmd, "OSGi Framework update").run();
    }

    public void uninstall() throws BundleException {
        throw new BundleException("The system bundle cannot be uninstalled");
    }

    public int getState() {
        return this.frameworkInit != null ? this.frameworkInit.getSystemBundle().getState() : this.frameworkBundleState;
    }

    public Dictionary<String, String> getHeaders() {
        this.assertNotStopped();
        return this.awaitFrameworkInit().getSystemBundle().getHeaders();
    }

    public ServiceReference[] getRegisteredServices() {
        this.assertNotStopped();
        return this.awaitFrameworkInit().getSystemBundle().getRegisteredServices();
    }

    public ServiceReference[] getServicesInUse() {
        this.assertNotStopped();
        return this.awaitFrameworkInit().getSystemBundle().getServicesInUse();
    }

    public boolean hasPermission(Object permission) {
        this.assertNotStopped();
        return this.awaitFrameworkInit().getSystemBundle().hasPermission(permission);
    }

    public URL getResource(String name) {
        this.assertNotStopped();
        return this.awaitFrameworkInit().getSystemBundle().getResource(name);
    }

    public Dictionary<String, String> getHeaders(String locale) {
        this.assertNotStopped();
        return this.awaitFrameworkInit().getSystemBundle().getHeaders(locale);
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        this.assertNotStopped();
        return this.awaitFrameworkInit().getSystemBundle().loadClass(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        this.assertNotStopped();
        return this.awaitFrameworkInit().getSystemBundle().getResources(name);
    }

    public Enumeration<String> getEntryPaths(String path) {
        this.assertNotStopped();
        return this.awaitFrameworkInit().getSystemBundle().getEntryPaths(path);
    }

    public URL getEntry(String path) {
        this.assertNotStopped();
        return this.awaitFrameworkInit().getSystemBundle().getEntry(path);
    }

    public long getLastModified() {
        this.assertNotStopped();
        return this.awaitFrameworkInit().getSystemBundle().getLastModified();
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        this.assertNotStopped();
        return this.awaitFrameworkInit().getSystemBundle().findEntries(path, filePattern, recurse);
    }

    public BundleContext getBundleContext() {
        return this.serviceStopped ? null : this.awaitFrameworkInit().getSystemBundle().getBundleContext();
    }

    public Map getSignerCertificates(int signersType) {
        throw new NotImplementedException();
    }

    private void assertNotStopped() {
        if (this.serviceStopped) {
            throw new IllegalStateException("Framework already stopped");
        }
    }

    private FrameworkState awaitFrameworkInit() {
        if (this.frameworkInit == null) {
            ServiceController controller = this.serviceContainer.getRequiredService(ServiceNames.FRAMEWORK_INIT);
            controller.addListener((ServiceListener)new AbstractServiceListener<FrameworkService>(){

                public void serviceStopped(ServiceController<? extends FrameworkService> controller) {
                    controller.removeListener((ServiceListener)this);
                    FrameworkProxy.this.frameworkBundleState = 4;
                    FrameworkProxy.this.serviceStopped = true;
                    FrameworkProxy.this.frameworkInit = null;
                }
            });
            controller.setMode(ServiceController.Mode.ACTIVE);
            FutureServiceValue future = new FutureServiceValue(controller);
            try {
                Integer timeout = (Integer)this.frameworkBuilder.getProperty("org.jboss.osgi.framework.init.timeout", 5000);
                FrameworkService service = (FrameworkService)future.get(timeout.intValue(), TimeUnit.MILLISECONDS);
                this.frameworkInit = service.getFrameworkState();
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause();
                throw new IllegalStateException("Cannot initialize Framework", cause);
            }
            catch (TimeoutException e) {
                throw new IllegalStateException("Timeout starting Framework");
            }
        }
        return this.frameworkInit;
    }

    private FrameworkState awaitActiveFramework() {
        if (this.activeFramework == null) {
            ServiceController controller = this.serviceContainer.getRequiredService(ServiceNames.FRAMEWORK_ACTIVE);
            controller.addListener((ServiceListener)new AbstractServiceListener<FrameworkService>(){

                public void serviceStopped(ServiceController<? extends FrameworkService> controller) {
                    controller.removeListener((ServiceListener)this);
                    FrameworkProxy.this.activeFramework = null;
                }
            });
            controller.setMode(ServiceController.Mode.ACTIVE);
            FutureServiceValue future = new FutureServiceValue(controller);
            try {
                Integer timeout = (Integer)this.frameworkBuilder.getProperty("org.jboss.osgi.framework.start.timeout", 10000);
                FrameworkService service = (FrameworkService)future.get(timeout.intValue(), TimeUnit.MILLISECONDS);
                this.activeFramework = service.getFrameworkState();
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause();
                throw new IllegalStateException("Cannot start the Framework", cause);
            }
            catch (TimeoutException e) {
                throw new IllegalStateException("Timeout start the Framework");
            }
        }
        return this.activeFramework;
    }
}

