/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.spi.NotImplementedException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;

abstract class FrameworkService
implements Service<FrameworkService>,
Framework {
    static final Logger log = Logger.getLogger(FrameworkService.class);

    FrameworkService() {
    }

    public void start(StartContext context) throws StartException {
        log.debugf("Starting: %s", (Object)context.getController().getName());
    }

    public void stop(StopContext context) {
        log.debugf("Stopping: %s", (Object)context.getController().getName());
    }

    public FrameworkService getValue() {
        return this;
    }

    abstract FrameworkState getFrameworkState();

    BundleManager getBundleManager() {
        return this.getFrameworkState().getBundleManager();
    }

    SystemBundleState getSystemBundle() {
        return this.getFrameworkState().getSystemBundle();
    }

    void changeState(int newstate) {
        throw new NotImplementedException();
    }

    public int getState() {
        return this.getSystemBundle().getState();
    }

    public Dictionary<String, String> getHeaders() {
        return this.getSystemBundle().getHeaders();
    }

    public long getBundleId() {
        return this.getSystemBundle().getBundleId();
    }

    public String getLocation() {
        return this.getSystemBundle().getLocation();
    }

    public ServiceReference[] getRegisteredServices() {
        return this.getSystemBundle().getRegisteredServices();
    }

    public ServiceReference[] getServicesInUse() {
        return this.getSystemBundle().getServicesInUse();
    }

    public boolean hasPermission(Object permission) {
        return this.getSystemBundle().hasPermission(permission);
    }

    public URL getResource(String name) {
        return this.getSystemBundle().getResource(name);
    }

    public Dictionary<String, String> getHeaders(String locale) {
        return this.getSystemBundle().getHeaders(locale);
    }

    public String getSymbolicName() {
        return this.getSystemBundle().getSymbolicName();
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.getSystemBundle().loadClass(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.getSystemBundle().getResources(name);
    }

    public Enumeration<String> getEntryPaths(String path) {
        return this.getSystemBundle().getEntryPaths(path);
    }

    public URL getEntry(String path) {
        return this.getSystemBundle().getEntry(path);
    }

    public long getLastModified() {
        return this.getSystemBundle().getLastModified();
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        return this.getSystemBundle().findEntries(path, filePattern, recurse);
    }

    public BundleContext getBundleContext() {
        return this.getSystemBundle().getBundleContext();
    }

    public Map getSignerCertificates(int signersType) {
        return this.getSystemBundle().getSignerCertificates(signersType);
    }

    public Version getVersion() {
        return this.getSystemBundle().getVersion();
    }

    public void init() throws BundleException {
        throw new UnsupportedOperationException("Not supported on the service object");
    }

    public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        throw new UnsupportedOperationException("Not supported on the service object");
    }

    public void start(int options) throws BundleException {
        throw new UnsupportedOperationException("Not supported on the service object");
    }

    public void start() throws BundleException {
        throw new UnsupportedOperationException("Not supported on the service object");
    }

    public void stop(int options) throws BundleException {
        throw new UnsupportedOperationException("Not supported on the service object");
    }

    public void stop() throws BundleException {
        throw new UnsupportedOperationException("Not supported on the service object");
    }

    public void update(InputStream input) throws BundleException {
        throw new UnsupportedOperationException("Not supported on the service object");
    }

    public void update() throws BundleException {
        throw new UnsupportedOperationException("Not supported on the service object");
    }

    public void uninstall() throws BundleException {
        throw new UnsupportedOperationException("Not supported on the service object");
    }
}

