/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.StartException;

final class FutureServiceValue<T>
implements Future<T> {
    private static final Logger log = Logger.getLogger(FutureServiceValue.class);
    private ServiceController<T> controller;

    FutureServiceValue(ServiceController<T> controller) {
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        this.controller = controller;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.controller.getState() == ServiceController.State.UP;
    }

    @Override
    public T get() throws ExecutionException {
        try {
            return this.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            throw new ExecutionException(ex);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
        return this.getValue(timeout, unit);
    }

    private T getValue(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
        if (this.controller.getState() == ServiceController.State.UP) {
            return (T)this.controller.getValue();
        }
        final CountDownLatch latch = new CountDownLatch(1);
        AbstractServiceListener listener = new AbstractServiceListener<T>(){

            public void listenerAdded(ServiceController<? extends T> controller) {
                ServiceController.State state = controller.getState();
                if (state == ServiceController.State.UP || state == ServiceController.State.START_FAILED) {
                    this.listenerDone(controller);
                }
            }

            public void serviceStarted(ServiceController<? extends T> controller) {
                this.listenerDone(controller);
            }

            public void serviceFailed(ServiceController<? extends T> controller, StartException reason) {
                this.listenerDone(controller);
            }

            private void listenerDone(ServiceController<? extends T> controller) {
                controller.removeListener((ServiceListener)this);
                latch.countDown();
            }
        };
        this.controller.addListener((ServiceListener)listener);
        try {
            if (!latch.await(timeout, unit)) {
                TimeoutException cause = new TimeoutException("Timeout getting " + this.controller.getName());
                this.processExceptionCause(cause);
                throw cause;
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.controller.getState() == ServiceController.State.UP) {
            return (T)this.controller.getValue();
        }
        StartException startException = this.controller.getStartException();
        Throwable cause = startException != null ? startException.getCause() : null;
        String message = this.processExceptionCause(cause);
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof ExecutionException) {
            throw (ExecutionException)cause;
        }
        if (cause instanceof TimeoutException) {
            throw (TimeoutException)cause;
        }
        throw new ExecutionException(message, cause);
    }

    String processExceptionCause(Throwable cause) throws ExecutionException, TimeoutException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.controller.getServiceContainer().dumpServices(new PrintStream(baos));
        String message = "Cannot start " + this.controller.getName();
        log.debugf(message + "\n%s", (Object)baos.toString());
        log.errorf(message, new Object[0]);
        return message;
    }
}

