/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.RevisionContent;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleException;

final class HostBundleRevision
extends UserBundleRevision {
    static final Logger log = Logger.getLogger(HostBundleRevision.class);
    private List<FragmentBundleRevision> attachedFragments;

    HostBundleRevision(HostBundleState hostBundle, Deployment dep) throws BundleException {
        super(hostBundle, dep);
    }

    static HostBundleRevision assertUserRevision(AbstractBundleRevision bundleRev) {
        if (bundleRev == null) {
            throw new IllegalArgumentException("Null bundleRev");
        }
        if (!(bundleRev instanceof HostBundleRevision)) {
            throw new IllegalArgumentException("Not an HostRevision: " + bundleRev);
        }
        return (HostBundleRevision)bundleRev;
    }

    @Override
    HostBundleState getBundleState() {
        return (HostBundleState)super.getBundleState();
    }

    @Override
    void refreshRevisionInternal(XModule resModule) {
        this.attachedFragments = null;
    }

    void attachFragment(FragmentBundleRevision fragRev) {
        if (this.attachedFragments == null) {
            this.attachedFragments = new CopyOnWriteArrayList<FragmentBundleRevision>();
        }
        this.attachedFragments.add(fragRev);
    }

    List<FragmentBundleRevision> getAttachedFragments() {
        if (this.attachedFragments == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.attachedFragments);
    }

    @Override
    Class<?> loadClass(String className) throws ClassNotFoundException {
        if (!this.getBundleState().ensureResolved(false)) {
            throw new ClassNotFoundException("Class '" + className + "' not found in: " + this);
        }
        ModuleClassLoader loader = this.getModuleClassLoader();
        return loader.loadClass(className, true);
    }

    @Override
    Enumeration<URL> findEntries(String path, String pattern, boolean recurse) {
        this.getBundleState().ensureResolved(true);
        Enumeration<URL> hostEntries = super.findEntries(path, pattern, recurse);
        List<FragmentBundleRevision> fragments = this.getAttachedFragments();
        if (fragments.size() == 0) {
            return hostEntries;
        }
        ArrayList<URL> allEntries = hostEntries == null ? new ArrayList<URL>() : new ArrayList<URL>(Collections.list(hostEntries));
        for (FragmentBundleRevision fragmentRevision : fragments) {
            Enumeration<URL> fragEntries = fragmentRevision.findEntries(path, pattern, recurse);
            if (fragEntries == null) continue;
            allEntries.addAll(Collections.list(fragEntries));
        }
        if (allEntries.size() == 0) {
            return null;
        }
        return Collections.enumeration(allEntries);
    }

    @Override
    URL getResource(String path) {
        this.getBundleState().assertNotUninstalled();
        if (this.getBundleState().ensureResolved(false)) {
            return this.getModuleClassLoader().getResource(path);
        }
        return this.getEntry(path);
    }

    @Override
    Enumeration<URL> getResources(String path) throws IOException {
        this.getBundleState().assertNotUninstalled();
        if (this.getBundleState().ensureResolved(true)) {
            Enumeration resources = this.getModuleClassLoader().getResources(path);
            return resources.hasMoreElements() ? resources : null;
        }
        Iterator<RevisionContent> i$ = this.getContentList().iterator();
        if (i$.hasNext()) {
            RevisionContent revContent = i$.next();
            try {
                VirtualFile child = revContent.getVirtualFile().getChild(path);
                if (child == null) {
                    return null;
                }
                Vector<URL> vector = new Vector<URL>();
                vector.add(child.toURL());
                return vector.elements();
            }
            catch (IOException ex) {
                log.errorf((Throwable)ex, "Cannot get resources: %s", (Object)path);
                return null;
            }
        }
        return null;
    }

    @Override
    URL getLocalizationEntry(String path) {
        URL entry = this.getEntry(path);
        if (entry != null) {
            return entry;
        }
        for (FragmentBundleRevision fragrev : this.getAttachedFragments()) {
            if (fragrev.getBundleState().isUninstalled() || (entry = fragrev.getEntry(path)) == null) continue;
            return entry;
        }
        return null;
    }
}

