/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.Resource;
import org.jboss.modules.filter.PathFilter;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.OSGiModuleLoader;
import org.osgi.framework.BundleException;

final class LazyActivationLocalLoader
implements LocalLoader {
    private static final Logger log = Logger.getLogger(LazyActivationLocalLoader.class);
    private final HostBundleState hostBundle;
    private final ModuleManagerPlugin moduleManager;
    private final ModuleIdentifier identifier;
    private final List<DependencySpec> moduleDependencies;
    private final PathFilter lazyPackagesFilter;
    private final AtomicBoolean relinkModule = new AtomicBoolean(true);
    private final AtomicBoolean activateHost = new AtomicBoolean(true);

    LazyActivationLocalLoader(HostBundleState hostBundle, ModuleIdentifier identifier, List<DependencySpec> moduleDependencies, PathFilter lazyFilter) {
        this.moduleDependencies = moduleDependencies;
        this.hostBundle = hostBundle;
        this.identifier = identifier;
        this.moduleManager = hostBundle.getFrameworkState().getModuleManagerPlugin();
        this.lazyPackagesFilter = lazyFilter;
    }

    public Class<?> loadClassLocal(String className, boolean resolve) {
        Class definedClass = null;
        String pathForClassName = this.getPathForClassName(className);
        if (this.lazyPackagesFilter.accept(pathForClassName)) {
            try {
                Module module = this.moduleManager.getModule(this.identifier);
                if (this.relinkModule.getAndSet(false)) {
                    log.debugf("Relinking [%s] on class load: %s", (Object)this.identifier, (Object)className);
                    OSGiModuleLoader moduleLoader = this.moduleManager.getModuleLoader();
                    ArrayList<DependencySpec> dependencies = new ArrayList<DependencySpec>(this.moduleDependencies);
                    dependencies.add(DependencySpec.createLocalDependencySpec());
                    moduleLoader.setAndRelinkDependencies(module, dependencies);
                }
                definedClass = module.getClassLoader().loadClass(className);
            }
            catch (ModuleLoadException ex) {
                throw new IllegalStateException(ex);
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
            if (this.activateHost.getAndSet(false)) {
                try {
                    log.debugf("Lazy activation [%s] on class load: %s", (Object)this.identifier, (Object)className);
                    this.hostBundle.activateOnClassLoad(definedClass);
                }
                catch (BundleException ex) {
                    log.errorf((Throwable)ex, "Cannot activate lazily: %s", (Object)this.hostBundle);
                }
            }
        }
        return definedClass;
    }

    private String getPathForClassName(String className) {
        if (className.endsWith(".class")) {
            className = className.substring(0, className.length() - 6);
        }
        className = className.substring(0, className.lastIndexOf(46));
        className = className.replace('.', '/');
        return className;
    }

    public List<Resource> loadResourceLocal(String name) {
        return Collections.emptyList();
    }
}

