/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.interceptor.AbstractLifecycleInterceptorService;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorService;
import org.jboss.osgi.deployment.internal.InvocationContextImpl;
import org.jboss.osgi.framework.ServiceNames;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleWrapper;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.RevisionContent;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.spi.Attachments;
import org.jboss.osgi.spi.util.AttachmentSupport;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

final class LifecycleInterceptorPlugin
extends AbstractPluginService<LifecycleInterceptorPlugin>
implements LifecycleInterceptorService {
    final Logger log = Logger.getLogger(LifecycleInterceptorPlugin.class);
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private AbstractLifecycleInterceptorService delegate;
    private ServiceRegistration registration;

    static void addService(ServiceTarget serviceTarget) {
        LifecycleInterceptorPlugin service = new LifecycleInterceptorPlugin();
        ServiceBuilder builder = serviceTarget.addService(InternalServices.LIFECYCLE_INTERCEPTOR_PLUGIN, (Service)service);
        builder.addDependency(ServiceNames.SYSTEM_CONTEXT, BundleContext.class, service.injectedSystemContext);
        builder.addDependency(ServiceNames.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private LifecycleInterceptorPlugin() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        final BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        this.delegate = new AbstractLifecycleInterceptorService(systemContext){

            protected InvocationContext getInvocationContext(Bundle bundle) {
                AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle);
                if (bundleState == null) {
                    throw new IllegalStateException("Cannot obtain bundleState for: " + bundle);
                }
                UserBundleState userBundle = UserBundleState.assertBundleState(bundleState);
                Deployment dep = userBundle.getDeployment();
                InvocationContext inv = (InvocationContext)dep.getAttachment(InvocationContext.class);
                if (inv == null) {
                    RevisionContent revContent = userBundle.getFirstContentRoot();
                    VirtualFile rootFile = revContent != null ? revContent.getVirtualFile() : null;
                    LifecycleInterceptorAttachments att = new LifecycleInterceptorAttachments();
                    inv = new InvocationContextImpl(systemContext, new BundleWrapper<AbstractBundleState>(bundleState), rootFile, (Attachments)att);
                    dep.addAttachment(InvocationContext.class, (Object)inv);
                }
                return inv;
            }
        };
        this.registration = systemContext.registerService(LifecycleInterceptorService.class.getName(), (Object)this.delegate, null);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.registration.unregister();
        this.registration = null;
        this.delegate = null;
    }

    public LifecycleInterceptorPlugin getValue() {
        return this;
    }

    public void handleStateChange(int state, Bundle bundle) {
        if (this.delegate != null) {
            this.delegate.handleStateChange(state, bundle);
        }
    }

    static class LifecycleInterceptorAttachments
    extends AttachmentSupport {
        LifecycleInterceptorAttachments() {
        }
    }
}

