/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.ServiceNames;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.BundleStorageState;
import org.jboss.osgi.framework.internal.DeploymentFactoryPlugin;
import org.jboss.osgi.framework.internal.InternalServices;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public final class PersistentBundlesInstaller
extends AbstractPluginService<Void> {
    static final Logger log = Logger.getLogger(PersistentBundlesInstaller.class);
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<BundleStoragePlugin> injectedBundleStorage = new InjectedValue();
    private final InjectedValue<DeploymentFactoryPlugin> injectedDeploymentFactory = new InjectedValue();

    static void addService(ServiceTarget serviceTarget) {
        PersistentBundlesInstaller service = new PersistentBundlesInstaller();
        ServiceBuilder builder = serviceTarget.addService(InternalServices.PERSISTENT_BUNDLES_INSTALLER, (Service)service);
        builder.addDependency(ServiceNames.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
        builder.addDependency(InternalServices.BUNDLE_STORAGE_PLUGIN, BundleStoragePlugin.class, service.injectedBundleStorage);
        builder.addDependency(InternalServices.DEPLOYMENT_FACTORY_PLUGIN, DeploymentFactoryPlugin.class, service.injectedDeploymentFactory);
        builder.addDependency(InternalServices.CORE_SERVICES);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private PersistentBundlesInstaller() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        try {
            ServiceTarget serviceTarget = context.getChildTarget();
            this.installPersistedBundles(serviceTarget);
        }
        catch (BundleException ex) {
            throw new StartException((Throwable)ex);
        }
    }

    private void installPersistedBundles(ServiceTarget serviceTarget) throws BundleException {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        BundleStoragePlugin storagePlugin = (BundleStoragePlugin)((Object)this.injectedBundleStorage.getValue());
        DeploymentFactoryPlugin deploymentPlugin = (DeploymentFactoryPlugin)((Object)this.injectedDeploymentFactory.getValue());
        final HashMap<ServiceName, Deployment> pendingServices = new HashMap<ServiceName, Deployment>();
        try {
            List<BundleStorageState> storageStates = storagePlugin.getBundleStorageStates();
            for (BundleStorageState storageState : storageStates) {
                long bundleId = storageState.getBundleId();
                if (bundleId == 0L) continue;
                try {
                    Deployment dep = deploymentPlugin.createDeployment(storageState);
                    ServiceName serviceName = bundleManager.installBundle(serviceTarget, dep);
                    pendingServices.put(serviceName, dep);
                }
                catch (BundleException ex) {
                    log.errorf((Throwable)ex, "Cannot install persistet bundle: %s", (Object)storageState);
                }
            }
        }
        catch (IOException ex) {
            throw new BundleException("Cannot install persisted bundles", (Throwable)ex);
        }
        ServiceName servicesInstalled = InternalServices.PERSISTENT_BUNDLES_INSTALLER.append(new String[]{"INSTALLED"});
        ServiceBuilder builder = serviceTarget.addService(servicesInstalled, (Service)new AbstractService<Void>(){

            public void start(StartContext context) throws StartException {
                log.debugf("Persistent bundles installed", new Object[0]);
            }
        });
        builder.addDependencies(pendingServices.keySet());
        builder.install();
        builder = serviceTarget.addService(InternalServices.PERSISTENT_BUNDLES_INSTALLER_COMPLETE, (Service)new AbstractService<Void>(){

            public void start(StartContext context) throws StartException {
                for (Deployment dep : pendingServices.values()) {
                    if (!dep.isAutoStart()) continue;
                    Bundle bundle = (Bundle)dep.getAttachment(Bundle.class);
                    try {
                        bundle.start();
                    }
                    catch (BundleException ex) {
                        log.errorf((Throwable)ex, "Cannot start persistent bundle: %s", (Object)bundle);
                    }
                }
                log.debugf("Persistent bundles started", new Object[0]);
            }
        });
        builder.addDependencies(new ServiceName[]{servicesInstalled});
        builder.install();
    }
}

