/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.Vector;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.EntriesProvider;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;

final class RevisionContent
implements EntriesProvider {
    static final Logger log = Logger.getLogger(RevisionContent.class);
    private final UserBundleRevision userRev;
    private final VirtualFile virtualFile;
    private final String identity;
    private final int contentId;

    RevisionContent(UserBundleRevision userRev, int contentId, VirtualFile rootFile) {
        if (userRev == null) {
            throw new IllegalArgumentException("Null userRev");
        }
        if (rootFile == null) {
            throw new IllegalArgumentException("Null rootFile");
        }
        this.userRev = userRev;
        this.virtualFile = rootFile;
        this.contentId = contentId;
        AbstractBundleState bundleState = userRev.getBundleState();
        String symbolicName = bundleState.getSymbolicName();
        if (symbolicName != null) {
            symbolicName = symbolicName.replace(':', '.');
            symbolicName = symbolicName.replace('-', '.');
        } else {
            symbolicName = "anonymous";
        }
        long bundleId = bundleState.getBundleId();
        int revisionId = userRev.getRevisionId();
        this.identity = symbolicName + "-" + bundleId + "-" + revisionId + "-" + contentId;
    }

    static RevisionContent findRevisionContent(BundleManager bundleManager, String identity) {
        if (identity == null) {
            throw new IllegalArgumentException("Null identity");
        }
        String[] parts = identity.split("-");
        if (parts.length != 4) {
            throw new IllegalArgumentException("Invalid identity: " + identity);
        }
        long bundleId = Long.parseLong(parts[1]);
        int revisionId = Integer.parseInt(parts[2]);
        int contentId = Integer.parseInt(parts[3]);
        AbstractBundleState bundleState = bundleManager.getBundleById(bundleId);
        if (bundleState == null) {
            return null;
        }
        AbstractBundleRevision bundleRev = bundleState.getRevisionById(revisionId);
        if (bundleRev == null) {
            return null;
        }
        UserBundleRevision userRev = (UserBundleRevision)bundleRev;
        RevisionContent revContent = userRev.getContentById(contentId);
        return revContent;
    }

    int getContentId() {
        return this.contentId;
    }

    String getIdentity() {
        return this.identity;
    }

    UserBundleRevision getRevision() {
        return this.userRev;
    }

    VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @Override
    public URL getEntry(String path) {
        try {
            VirtualFile child = this.virtualFile.getChild(path);
            return child != null ? this.getBundleURL(child) : null;
        }
        catch (IOException ex) {
            log.errorf((Throwable)ex, "Cannot get entry: %s", (Object)path);
            return null;
        }
    }

    @Override
    public Enumeration<URL> findEntries(String path, String pattern, boolean recurse) {
        try {
            Enumeration urls = this.virtualFile.findEntries(path, pattern, recurse);
            return this.getBundleURLs(urls);
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public Enumeration<String> getEntryPaths(String path) {
        try {
            Enumeration entryPaths = this.virtualFile.getEntryPaths(path);
            if (entryPaths != null && entryPaths.hasMoreElements()) {
                return entryPaths;
            }
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    void close() {
        VFSUtils.safeClose((Closeable)this.virtualFile);
    }

    private Enumeration<URL> getBundleURLs(Enumeration<URL> urls) throws IOException {
        if (urls == null) {
            return null;
        }
        if (!urls.hasMoreElements()) {
            return null;
        }
        Vector<URL> result = new Vector<URL>();
        while (urls.hasMoreElements()) {
            VirtualFile child = AbstractVFS.toVirtualFile((URL)urls.nextElement());
            result.add(this.getBundleURL(child));
        }
        return result.elements();
    }

    URL getBundleURL(final VirtualFile child) throws IOException {
        final String orgPath = child.getPathName();
        URLStreamHandler streamHandler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL url) throws IOException {
                String path = url.getPath();
                VirtualFile real = orgPath.equals(path) ? child : RevisionContent.this.virtualFile.getChild(path);
                return real.toURL().openConnection();
            }
        };
        String rootPath = this.virtualFile.getPathName();
        String pathName = child.getPathName().substring(rootPath.length());
        StringBuilder path = new StringBuilder(pathName.length() + 2);
        if (!pathName.startsWith("/")) {
            path.append('/');
        }
        path.append(pathName);
        if (child.isDirectory() && path.charAt(path.length() - 1) != '/') {
            path.append('/');
        }
        return new URL("bundle", this.identity, -1, path.toString(), streamHandler);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RevisionContent)) {
            return false;
        }
        RevisionContent other = (RevisionContent)obj;
        return this.identity.equals(other.identity);
    }

    public String toString() {
        return "[id=" + this.identity + ",vfile=" + this.virtualFile + "]";
    }
}

