/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.framework.ServiceNames;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.ServiceManagerPlugin;
import org.jboss.osgi.framework.internal.ServiceReferenceComparator;
import org.jboss.osgi.framework.internal.ServiceReferenceWrapper;
import org.jboss.osgi.framework.internal.ServiceRegistrationWrapper;
import org.jboss.osgi.metadata.CaseInsensitiveDictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

final class ServiceState
implements ServiceRegistration,
ServiceReference {
    private static final Logger log = Logger.getLogger(ServiceState.class);
    private final ServiceManagerPlugin serviceManager;
    private final AbstractBundleState ownerBundle;
    private final Set<ServiceName> serviceNames;
    private final long serviceId;
    private final ValueProvider valueProvider;
    private final ServiceReference reference;
    private ServiceRegistration registration;
    private Set<AbstractBundleState> usingBundles;
    private Map<Long, ServiceFactoryHolder> factoryValues;
    private CaseInsensitiveDictionary prevProperties;
    private CaseInsensitiveDictionary currProperties;

    ServiceState(ServiceManagerPlugin serviceManager, AbstractBundleState owner, long serviceId, String[] clazzes, ValueProvider valueProvider, Dictionary properties) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("Null serviceManager");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Null owner");
        }
        if (clazzes == null || clazzes.length == 0) {
            throw new IllegalArgumentException("Null clazzes");
        }
        if (valueProvider == null) {
            throw new IllegalArgumentException("Null valueProvider");
        }
        this.serviceManager = serviceManager;
        this.ownerBundle = owner;
        this.serviceId = serviceId;
        this.valueProvider = valueProvider;
        if (!this.checkValidClassNames(owner, clazzes, valueProvider.getValue())) {
            throw new IllegalArgumentException("Invalid object class in: " + Arrays.asList(clazzes));
        }
        this.serviceNames = new HashSet<ServiceName>(clazzes.length);
        for (int i = 0; i < clazzes.length; ++i) {
            if (clazzes[i] == null) {
                throw new IllegalArgumentException("Null service class at index: " + i);
            }
            ServiceName serviceName = ServiceState.createServiceName(clazzes[i]);
            this.serviceNames.add(serviceName);
        }
        if (properties == null) {
            properties = new Hashtable<String, Long>();
        }
        ((Dictionary)properties).put("service.id", serviceId);
        ((Dictionary)properties).put("objectClass", (Long)clazzes);
        this.currProperties = new CaseInsensitiveDictionary(properties);
        this.registration = new ServiceRegistrationWrapper(this);
        this.reference = new ServiceReferenceWrapper(this);
    }

    static ServiceState assertServiceState(ServiceReference sref) {
        if (sref == null) {
            throw new IllegalArgumentException("Null sref");
        }
        if (sref instanceof ServiceReferenceWrapper) {
            sref = ((ServiceReferenceWrapper)sref).getServiceState();
        }
        return (ServiceState)sref;
    }

    long getServiceId() {
        return this.serviceId;
    }

    static ServiceName createXServiceName(String clazz) {
        return ServiceNames.JBOSGI_XSERVICE_BASE_NAME.append(new String[]{clazz});
    }

    static ServiceName createServiceName(String clazz) {
        return ServiceNames.JBOSGI_SERVICE_BASE_NAME.append(new String[]{clazz});
    }

    Object getRawValue() {
        return this.valueProvider.getValue();
    }

    Object getScopedValue(AbstractBundleState bundleState) {
        Object value = this.valueProvider.getValue();
        if (!(value instanceof ServiceFactory)) {
            return value;
        }
        Object result = null;
        try {
            ServiceFactoryHolder factoryHolder;
            if (this.factoryValues == null) {
                this.factoryValues = new HashMap<Long, ServiceFactoryHolder>();
            }
            if ((factoryHolder = this.factoryValues.get(bundleState.getBundleId())) == null) {
                ServiceFactory factory = (ServiceFactory)value;
                factoryHolder = new ServiceFactoryHolder(bundleState, factory);
                this.factoryValues.put(bundleState.getBundleId(), factoryHolder);
            }
            if ((result = factoryHolder.getService()) == null) {
                ServiceException sex = new ServiceException("Cannot get factory value", 2);
                FrameworkEventsPlugin eventsPlugin = this.serviceManager.getFrameworkEventsPlugin();
                eventsPlugin.fireFrameworkEvent(bundleState, 2, (Throwable)sex);
            }
        }
        catch (Throwable th) {
            ServiceException sex = new ServiceException("Cannot get factory value", 3, th);
            FrameworkEventsPlugin eventsPlugin = this.serviceManager.getFrameworkEventsPlugin();
            eventsPlugin.fireFrameworkEvent(bundleState, 2, (Throwable)sex);
        }
        return result;
    }

    void ungetScopedValue(AbstractBundleState bundleState) {
        Object value = this.valueProvider.getValue();
        if (value instanceof ServiceFactory) {
            try {
                ServiceFactoryHolder factoryHolder = this.factoryValues.get(bundleState.getBundleId());
                factoryHolder.ungetService();
            }
            catch (RuntimeException rte) {
                ServiceException sex = new ServiceException("Cannot unget factory value", 3, (Throwable)rte);
                FrameworkEventsPlugin eventsPlugin = this.serviceManager.getFrameworkEventsPlugin();
                eventsPlugin.fireFrameworkEvent(bundleState, 16, (Throwable)sex);
            }
        }
    }

    ServiceRegistration getRegistration() {
        return this.registration;
    }

    Set<ServiceName> getServiceNames() {
        return Collections.unmodifiableSet(this.serviceNames);
    }

    public ServiceReference getReference() {
        this.assertNotUnregistered();
        return this.reference;
    }

    public void unregister() {
        this.assertNotUnregistered();
        this.unregisterInternal();
    }

    void unregisterInternal() {
        this.serviceManager.unregisterService(this);
        this.usingBundles = null;
        this.registration = null;
    }

    public Object getProperty(String key) {
        if (key == null) {
            return null;
        }
        return this.currProperties.get((Object)key);
    }

    public String[] getPropertyKeys() {
        ArrayList result = new ArrayList();
        if (this.currProperties != null) {
            Enumeration keys = this.currProperties.keys();
            while (keys.hasMoreElements()) {
                result.add(keys.nextElement());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public void setProperties(Dictionary properties) {
        this.assertNotUnregistered();
        this.prevProperties = this.currProperties;
        if (properties == null) {
            properties = new Hashtable<String, Object>();
        }
        ((Dictionary)properties).put("service.id", this.currProperties.get((Object)"service.id"));
        ((Dictionary)properties).put("objectClass", this.currProperties.get((Object)"objectClass"));
        this.currProperties = new CaseInsensitiveDictionary(properties);
        FrameworkEventsPlugin eventsPlugin = this.serviceManager.getFrameworkEventsPlugin();
        eventsPlugin.fireServiceEvent(this.ownerBundle, 2, this);
    }

    Dictionary getPreviousProperties() {
        return this.prevProperties;
    }

    AbstractBundleState getServiceOwner() {
        return this.ownerBundle;
    }

    public Bundle getBundle() {
        if (this.isUnregistered()) {
            return null;
        }
        return this.ownerBundle.getBundleProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUsingBundle(AbstractBundleState bundleState) {
        ServiceState serviceState = this;
        synchronized (serviceState) {
            if (this.usingBundles == null) {
                this.usingBundles = new HashSet<AbstractBundleState>();
            }
            this.usingBundles.add(bundleState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUsingBundle(AbstractBundleState bundleState) {
        ServiceState serviceState = this;
        synchronized (serviceState) {
            if (this.usingBundles != null) {
                this.usingBundles.remove(bundleState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<AbstractBundleState> getUsingBundlesInternal() {
        ServiceState serviceState = this;
        synchronized (serviceState) {
            if (this.usingBundles == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(new HashSet<AbstractBundleState>(this.usingBundles));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getUsingBundles() {
        ServiceState serviceState = this;
        synchronized (serviceState) {
            if (this.usingBundles == null) {
                return null;
            }
            HashSet<Bundle> bundles = new HashSet<Bundle>();
            for (AbstractBundleState aux : this.usingBundles) {
                bundles.add(aux.getBundleProxy());
            }
            return bundles.toArray(new Bundle[bundles.size()]);
        }
    }

    public boolean isAssignableTo(Bundle bundle, String className) {
        if (bundle == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        if (className == null) {
            throw new IllegalArgumentException("Null className");
        }
        if (this.ownerBundle == AbstractBundleState.assertBundleState(bundle)) {
            return true;
        }
        Class targetClass = null;
        try {
            targetClass = bundle.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            log.tracef("Requesting bundle [%s] cannot load class: %s", (Object)bundle, (Object)className);
            return true;
        }
        Class<?> ownerClass = null;
        try {
            ownerClass = this.ownerBundle.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            log.warnf("Owner bundle cannot load class: %s", (Object)className);
            return false;
        }
        if (targetClass != ownerClass) {
            Object value = this.valueProvider.getValue();
            log.debugf("Not assignable: %s", (Object)value.getClass().getName());
            return false;
        }
        return true;
    }

    public int compareTo(Object sref) {
        if (!(sref instanceof ServiceReference)) {
            throw new IllegalArgumentException("Invalid sref: " + sref);
        }
        Comparator<ServiceReference> comparator = ServiceReferenceComparator.getInstance();
        return comparator.compare(this, (ServiceReference)sref);
    }

    int getServiceRanking() {
        Object prop = this.getProperty("service.ranking");
        if (!(prop instanceof Integer)) {
            return 0;
        }
        return (Integer)prop;
    }

    boolean isUnregistered() {
        return this.registration == null;
    }

    void assertNotUnregistered() {
        if (this.isUnregistered()) {
            throw new IllegalStateException("Service is unregistered: " + this);
        }
    }

    private boolean checkValidClassNames(AbstractBundleState bundleState, String[] classNames, Object value) {
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundleState");
        }
        if (classNames == null || classNames.length == 0) {
            throw new IllegalArgumentException("Null classNames");
        }
        if (value == null) {
            throw new IllegalArgumentException("Null value");
        }
        if (value instanceof ServiceFactory) {
            return true;
        }
        for (String className : classNames) {
            if (className == null) {
                throw new IllegalArgumentException("Null className");
            }
            try {
                Class<?> clazz = bundleState.loadClass(className);
                Class<?> valueClass = value.getClass();
                if (clazz.isAssignableFrom(valueClass)) continue;
                String format = "Service interface [%s] loaded from [%s] is not assignable from [%s] loaded from [%s]";
                log.errorf(format, new Object[]{className, clazz.getClassLoader(), valueClass.getName(), valueClass.getClassLoader()});
                return false;
            }
            catch (ClassNotFoundException ex) {
                log.errorf("Cannot load [%s] from: %s", (Object)className, (Object)bundleState);
                return false;
            }
        }
        return true;
    }

    public String toString() {
        Hashtable<String, List<String>> props = new Hashtable<String, List<String>>((Map<String, List<String>>)this.currProperties);
        String[] classes = (String[])props.get("objectClass");
        props.put("objectClass", Arrays.asList(classes));
        return "ServiceState" + props;
    }

    class ServiceFactoryHolder {
        ServiceFactory factory;
        AbstractBundleState bundleState;
        AtomicInteger useCount;
        Object value;

        ServiceFactoryHolder(AbstractBundleState bundleState, ServiceFactory factory) {
            this.bundleState = bundleState;
            this.factory = factory;
            this.useCount = new AtomicInteger();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getService() {
            if (this.useCount.get() == 0) {
                AbstractBundleState abstractBundleState = this.bundleState;
                synchronized (abstractBundleState) {
                    Object retValue = this.factory.getService(this.bundleState.getBundleProxy(), ServiceState.this.getRegistration());
                    if (retValue == null) {
                        return null;
                    }
                    if (!ServiceState.this.checkValidClassNames(ServiceState.this.ownerBundle, (String[])ServiceState.this.getProperty("objectClass"), retValue)) {
                        return null;
                    }
                    this.value = retValue;
                }
            }
            this.useCount.incrementAndGet();
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ungetService() {
            if (this.useCount.get() == 0) {
                return;
            }
            if (this.useCount.decrementAndGet() == 0) {
                AbstractBundleState abstractBundleState = this.bundleState;
                synchronized (abstractBundleState) {
                    this.factory.ungetService(this.bundleState.getBundleProxy(), ServiceState.this.getRegistration(), this.value);
                    this.value = null;
                }
            }
        }
    }

    static interface ValueProvider {
        public Object getValue();
    }
}

