/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.FrameworkModuleProvider;
import org.jboss.osgi.framework.ServiceNames;
import org.jboss.osgi.framework.internal.AbstractBundleService;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.internal.SystemPackagesPlugin;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.resolver.XModule;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public final class SystemBundleService
extends AbstractBundleService<SystemBundleState> {
    static final Logger log = Logger.getLogger(SystemBundleService.class);
    private final InjectedValue<SystemPackagesPlugin> injectedSystemPackages = new InjectedValue();
    private final InjectedValue<BundleStoragePlugin> injectedBundleStorage = new InjectedValue();
    private final InjectedValue<ResolverPlugin> injectedResolverPlugin = new InjectedValue();

    static void addService(ServiceTarget serviceTarget, FrameworkState frameworkState) {
        SystemBundleState bundleState = new SystemBundleState(frameworkState);
        SystemBundleService service = new SystemBundleService(bundleState);
        ServiceBuilder builder = serviceTarget.addService(ServiceNames.SYSTEM_BUNDLE, (Service)service);
        builder.addDependency(ServiceNames.FRAMEWORK_MODULE_PROVIDER, FrameworkModuleProvider.class, bundleState.injectedModuleProvider);
        builder.addDependency(InternalServices.SYSTEM_PACKAGES_PLUGIN, SystemPackagesPlugin.class, service.injectedSystemPackages);
        builder.addDependency(InternalServices.BUNDLE_STORAGE_PLUGIN, BundleStoragePlugin.class, service.injectedBundleStorage);
        builder.addDependency(InternalServices.RESOLVER_PLUGIN, ResolverPlugin.class, service.injectedResolverPlugin);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private SystemBundleService(SystemBundleState bundleState) {
        super(bundleState);
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        try {
            BundleManager bundleManager = this.getBundleManager();
            SystemBundleState bundleState = (SystemBundleState)this.getBundleState();
            bundleState.changeState(8);
            OSGiMetaData metadata = this.createOSGiMetaData();
            XModule resModule = bundleState.createResolverModule(metadata);
            bundleState.createBundleRevision(metadata, resModule);
            bundleState.createBundleContext();
            bundleState.createStorageState((BundleStoragePlugin)((Object)this.injectedBundleStorage.getValue()));
            ((ResolverPlugin)((Object)this.injectedResolverPlugin.getValue())).addModule(resModule);
            bundleManager.injectedSystemBundle.inject((Object)bundleState);
            bundleManager.addBundle(bundleState);
        }
        catch (BundleException ex) {
            throw new StartException((Throwable)ex);
        }
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        BundleManager bundleManager = this.getBundleManager();
        bundleManager.injectedSystemBundle.uninject();
    }

    private OSGiMetaData createOSGiMetaData() {
        OSGiMetaDataBuilder builder = OSGiMetaDataBuilder.createBuilder((String)this.getSymbolicName(), (Version)this.getVersion());
        SystemPackagesPlugin systemPackages = (SystemPackagesPlugin)((Object)this.injectedSystemPackages.getValue());
        ArrayList<String> exportedPackages = new ArrayList<String>();
        exportedPackages.addAll(systemPackages.getSystemPackages());
        exportedPackages.addAll(systemPackages.getFrameworkPackages());
        if (exportedPackages.isEmpty()) {
            throw new IllegalStateException("Framework system packages not available");
        }
        Iterator i$ = exportedPackages.iterator();
        while (i$.hasNext()) {
            String packageSpec;
            String packname = packageSpec = (String)i$.next();
            Version version = Version.emptyVersion;
            int versionIndex = packname.indexOf(";version=");
            if (versionIndex > 0) {
                packname = packageSpec.substring(0, versionIndex);
                version = Version.parseVersion((String)packageSpec.substring(versionIndex + 9));
            }
            builder.addExportPackages(new String[]{packname + ";version=" + version});
        }
        return builder.getOSGiMetaData();
    }
}

