/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.FrameworkModuleProvider;
import org.jboss.osgi.framework.ServiceNames;
import org.jboss.osgi.framework.internal.AbstractBundleContext;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleProxy;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.BundleStorageState;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.SystemBundleContext;
import org.jboss.osgi.framework.internal.SystemBundleProxy;
import org.jboss.osgi.framework.internal.SystemBundleRevision;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleBuilder;
import org.jboss.osgi.resolver.XResolverFactory;
import org.jboss.osgi.spi.NotImplementedException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

final class SystemBundleState
extends AbstractBundleState {
    static final Logger log = Logger.getLogger(SystemBundleState.class);
    final InjectedValue<FrameworkModuleProvider> injectedModuleProvider = new InjectedValue();
    private BundleStorageState storageState;
    private SystemBundleRevision revision;

    SystemBundleState(FrameworkState frameworkState) {
        super(frameworkState, 0L, "system.bundle");
    }

    static SystemBundleState assertBundleState(Bundle bundle) {
        if ((bundle = AbstractBundleState.assertBundleState(bundle)) instanceof BundleProxy) {
            bundle = ((BundleProxy)bundle).getBundleState();
        }
        if (!(bundle instanceof UserBundleState)) {
            throw new IllegalArgumentException("Not an UserBundleState: " + bundle);
        }
        return (SystemBundleState)bundle;
    }

    Module getFrameworkModule() {
        FrameworkModuleProvider moduleProvider = (FrameworkModuleProvider)this.injectedModuleProvider.getValue();
        return moduleProvider.getFrameworkModule(this);
    }

    void createBundleRevision(OSGiMetaData metadata, XModule resModule) throws BundleException {
        this.revision = new SystemBundleRevision(this, metadata, resModule);
    }

    XModule createResolverModule(OSGiMetaData metadata) throws BundleException {
        XResolverFactory factory = XResolverFactory.getInstance((ClassLoader)this.getClass().getClassLoader());
        XModuleBuilder moduleBuilder = factory.newModuleBuilder();
        XModule resModule = moduleBuilder.createModule(metadata, 0).getModule();
        resModule.addAttachment(Bundle.class, (Object)this);
        return resModule;
    }

    @Override
    List<XModule> getAllResolverModules() {
        return Collections.singletonList(this.getResolverModule());
    }

    void createStorageState(BundleStoragePlugin storagePlugin) {
        try {
            this.storageState = storagePlugin.createStorageState(0L, "system.bundle", null);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot create system persistence storage", ex);
        }
    }

    @Override
    ServiceName getServiceName() {
        return ServiceNames.SYSTEM_BUNDLE;
    }

    public String getLocation() {
        return "System Bundle";
    }

    @Override
    public Version getVersion() {
        return Version.emptyVersion;
    }

    @Override
    AbstractBundleContext createContextInternal() {
        return new SystemBundleContext(this);
    }

    @Override
    SystemBundleRevision getCurrentRevision() {
        return this.revision;
    }

    @Override
    BundleStorageState getBundleStorageState() {
        return this.storageState;
    }

    @Override
    boolean isFragment() {
        return false;
    }

    @Override
    boolean isSingleton() {
        return true;
    }

    @Override
    SystemBundleRevision getRevisionById(int revisionId) {
        if (revisionId != 0) {
            throw new IllegalArgumentException("System bundle does not have a revision with id: " + revisionId);
        }
        return this.revision;
    }

    @Override
    Bundle createBundleProxy() {
        return new SystemBundleProxy(this);
    }

    @Override
    void startInternal(int options) throws BundleException {
    }

    @Override
    void stopInternal(int options) throws BundleException {
    }

    @Override
    void updateInternal(InputStream input) throws BundleException {
        throw new NotImplementedException();
    }

    @Override
    void uninstallInternal() throws BundleException {
    }
}

