/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.internal.AbstractBundleService;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleStorageState;
import org.jboss.osgi.framework.internal.BundleValidatorR3;
import org.jboss.osgi.framework.internal.BundleValidatorR4;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.NativeCodePlugin;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XModule;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

abstract class UserBundleService<T extends UserBundleState>
extends AbstractBundleService<T> {
    private final Deployment initialDeployment;

    UserBundleService(T bundleState, Deployment dep) {
        super(bundleState);
        this.initialDeployment = dep;
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        BundleStorageState storageState = null;
        try {
            UserBundleState bundleState = (UserBundleState)this.getBundleState();
            Deployment dep = this.initialDeployment;
            dep.addAttachment(Bundle.class, (Object)bundleState);
            OSGiMetaData metadata = (OSGiMetaData)dep.getAttachment(OSGiMetaData.class);
            storageState = bundleState.createStorageState(dep);
            bundleState.createResolverModule(dep);
            bundleState.createRevision(dep);
            bundleState.initUserBundleState(metadata);
            this.validateBundle(bundleState, metadata);
            this.processNativeCode(bundleState, dep);
            this.getBundleManager().addBundle(bundleState);
            bundleState.changeState(2);
            this.addToResolver(bundleState);
        }
        catch (BundleException ex) {
            if (storageState != null) {
                storageState.deleteBundleStorage();
            }
            throw new StartException((Throwable)ex);
        }
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.getBundleManager().uninstallBundle((UserBundleState)this.getBundleState(), 1);
    }

    private void validateBundle(UserBundleState userBundle, OSGiMetaData metadata) throws BundleException {
        if (metadata.getBundleManifestVersion() > 1) {
            new BundleValidatorR4().validateBundle(userBundle, metadata);
        } else {
            new BundleValidatorR3().validateBundle(userBundle, metadata);
        }
    }

    private void processNativeCode(UserBundleState userBundle, Deployment dep) {
        OSGiMetaData metadata = userBundle.getOSGiMetaData();
        if (metadata.getBundleNativeCode() != null) {
            FrameworkState frameworkState = userBundle.getFrameworkState();
            NativeCodePlugin nativeCodePlugin = frameworkState.getNativeCodePlugin();
            nativeCodePlugin.deployNativeCode(dep);
        }
    }

    private void addToResolver(UserBundleState userBundle) {
        if (userBundle.isSingleton()) {
            for (AbstractBundleState aux : this.getBundleManager().getBundles(this.getSymbolicName(), null)) {
                if (aux == userBundle || !aux.isSingleton()) continue;
                log.infof("No resolvable singleton bundle: %s", (Object)this);
                return;
            }
        }
        FrameworkState frameworkState = userBundle.getFrameworkState();
        ResolverPlugin resolverPlugin = frameworkState.getResolverPlugin();
        XModule resModule = userBundle.getResolverModule();
        resolverPlugin.addModule(resModule);
    }
}

