/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleInstallHandler;
import org.jboss.osgi.framework.ServiceNames;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleProxy;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.BundleStorageState;
import org.jboss.osgi.framework.internal.DeploymentFactoryPlugin;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.framework.internal.RevisionContent;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleBuilder;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

abstract class UserBundleState
extends AbstractBundleState {
    static final Logger log = Logger.getLogger(UserBundleState.class);
    private final Semaphore uninstallSemaphore = new Semaphore(1);
    private final ServiceName serviceName;
    private final List<UserBundleRevision> revisions = new CopyOnWriteArrayList<UserBundleRevision>();
    private Dictionary<String, String> headersOnUninstall;
    private BundleStorageState storageState;

    UserBundleState(FrameworkState frameworkState, long bundleId, String symbolicName) throws BundleException {
        super(frameworkState, bundleId, symbolicName);
        this.serviceName = UserBundleState.getServiceName(bundleId);
    }

    static ServiceName getServiceName(long bundleId) {
        return ServiceNames.BUNDLE_BASE_NAME.append(new String[]{new Long(bundleId).toString()}).append(new String[]{"INSTALLED"});
    }

    static UserBundleState assertBundleState(Bundle bundle) {
        if ((bundle = AbstractBundleState.assertBundleState(bundle)) instanceof BundleProxy) {
            bundle = ((BundleProxy)bundle).getBundleState();
        }
        if (!(bundle instanceof UserBundleState)) {
            throw new IllegalArgumentException("Not an UserBundleState: " + bundle);
        }
        return (UserBundleState)bundle;
    }

    @Override
    BundleStorageState getBundleStorageState() {
        return this.storageState;
    }

    public String getLocation() {
        return this.getCurrentRevision().getLocation();
    }

    Deployment getDeployment() {
        return this.getCurrentRevision().getDeployment();
    }

    RevisionContent getFirstContentRoot() {
        return this.getCurrentRevision().getRootContent();
    }

    List<RevisionContent> getContentRoots() {
        return this.getCurrentRevision().getContentList();
    }

    @Override
    boolean isSingleton() {
        return this.getOSGiMetaData().isSingleton();
    }

    UserBundleRevision createRevision(Deployment deployment) throws BundleException {
        UserBundleRevision revision = this.createRevisionInternal(deployment);
        this.addRevision(revision);
        return revision;
    }

    XModule createResolverModule(Deployment dep) throws BundleException {
        XModule resModule = (XModule)dep.getAttachment(XModule.class);
        if (resModule == null) {
            OSGiMetaData metadata = (OSGiMetaData)dep.getAttachment(OSGiMetaData.class);
            String symbolicName = metadata.getBundleSymbolicName();
            Version version = metadata.getBundleVersion();
            BundleStorageState storageState = (BundleStorageState)dep.getAttachment(BundleStorageState.class);
            int modulerev = storageState.getRevisionId();
            for (AbstractBundleState aux : this.getBundleManager().getBundles(symbolicName, version.toString())) {
                if (aux.getState() != 1) continue;
                XModule auxmod = aux.getResolverModule();
                int auxrev = auxmod.getModuleId().getRevision();
                modulerev = Math.max(modulerev + 100, auxrev + 100);
            }
            FrameworkState frameworkState = this.getFrameworkState();
            ResolverPlugin resolverPlugin = frameworkState.getResolverPlugin();
            XModuleBuilder builder = resolverPlugin.getModuleBuilder();
            resModule = builder.createModule(metadata, modulerev).getModule();
            Module module = (Module)dep.getAttachment(Module.class);
            if (module != null) {
                resModule.addAttachment(Module.class, (Object)module);
            }
            dep.addAttachment(XModule.class, (Object)resModule);
        }
        resModule.addAttachment(Bundle.class, (Object)this);
        return resModule;
    }

    abstract void initUserBundleState(OSGiMetaData var1);

    abstract UserBundleRevision createRevisionInternal(Deployment var1) throws BundleException;

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        if (this.getState() == 1) {
            return this.headersOnUninstall;
        }
        return super.getHeaders(locale);
    }

    @Override
    ServiceName getServiceName() {
        return this.serviceName;
    }

    void addRevision(UserBundleRevision rev) {
        this.revisions.add(0, rev);
    }

    @Override
    UserBundleRevision getCurrentRevision() {
        return this.revisions.get(0);
    }

    List<UserBundleRevision> getRevisions() {
        return Collections.unmodifiableList(this.revisions);
    }

    void clearRevisions() {
        UserBundleRevision rev = this.getCurrentRevision();
        this.revisions.clear();
        this.revisions.add(rev);
    }

    @Override
    AbstractBundleRevision getRevisionById(int revisionId) {
        for (UserBundleRevision rev : this.revisions) {
            if (rev.getRevisionId() != revisionId) continue;
            return rev;
        }
        return null;
    }

    boolean aquireUninstallLock() {
        try {
            log.tracef("Aquire uninstall lock: %s", (Object)this);
            boolean result = this.uninstallSemaphore.tryAcquire(10L, TimeUnit.SECONDS);
            if (!result) {
                log.warnf("Cannot acquire unstall lock for: %s", (Object)this);
            }
            return result;
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    void releaseUninstallLock() {
        log.tracef("Release uninstall lock: %s", (Object)this);
        this.uninstallSemaphore.release();
    }

    boolean hasActiveWires() {
        XModule resModule = this.getResolverModule();
        if (!resModule.isResolved()) {
            return false;
        }
        for (XCapability cap : resModule.getCapabilities()) {
            Set wiredReqs = cap.getWiredRequirements();
            for (XRequirement req : wiredReqs) {
                Bundle bundle = (Bundle)req.getModule().getAttachment(Bundle.class);
                AbstractBundleState importer = AbstractBundleState.assertBundleState(bundle);
                if (importer.getState() == 1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    List<XModule> getAllResolverModules() {
        ArrayList<XModule> allModules = new ArrayList<XModule>();
        for (UserBundleRevision rev : this.getRevisions()) {
            allModules.add(rev.getResolverModule());
        }
        return allModules;
    }

    @Override
    void updateInternal(InputStream input) throws BundleException {
        int state;
        boolean restart = false;
        if (!(this.isFragment() || (state = this.getState()) != 32 && state != 8 && state != 16)) {
            this.stopInternal(1);
            if (state != 16) {
                restart = true;
            }
        }
        this.changeState(2, 64);
        try {
            this.createUpdateRevision(input);
        }
        catch (BundleException ex) {
            if (restart) {
                this.startInternal(1);
            }
            throw ex;
        }
        catch (Exception ex) {
            BundleException be = new BundleException("Problem updating bundle");
            be.initCause((Throwable)ex);
            if (restart) {
                this.startInternal(1);
            }
            throw be;
        }
        FrameworkEventsPlugin eventsPlugin = this.getFrameworkState().getFrameworkEventsPlugin();
        eventsPlugin.fireBundleEvent(this, 8);
        if (restart) {
            try {
                this.startInternal(1);
            }
            catch (BundleException e) {
                eventsPlugin.fireFrameworkEvent(this, 2, e);
            }
        }
    }

    private void createUpdateRevision(InputStream input) throws Exception {
        VirtualFile rootFile = null;
        if (input == null) {
            String updateLocation = this.getOSGiMetaData().getHeader("Bundle-UpdateLocation");
            if (updateLocation != null) {
                URL updateURL = new URL(updateLocation);
                rootFile = AbstractVFS.toVirtualFile((URL)updateURL);
            } else {
                rootFile = this.getFirstContentRoot().getVirtualFile();
            }
        }
        if (rootFile == null && input != null) {
            rootFile = AbstractVFS.toVirtualFile((InputStream)input);
        }
        BundleStorageState storageState = this.createStorageState(this.getLocation(), rootFile);
        DeploymentFactoryPlugin deploymentPlugin = this.getFrameworkState().getDeploymentFactoryPlugin();
        Deployment dep = deploymentPlugin.createDeployment(storageState);
        OSGiMetaData metadata = deploymentPlugin.createOSGiMetaData(dep);
        dep.addAttachment(OSGiMetaData.class, (Object)metadata);
        dep.addAttachment(Bundle.class, (Object)this);
        XModule resModule = this.createResolverModule(dep);
        this.createRevision(dep);
        ResolverPlugin resolverPlugin = this.getFrameworkState().getResolverPlugin();
        resolverPlugin.addModule(resModule);
    }

    BundleStorageState createStorageState(Deployment dep) throws BundleException {
        this.storageState = (BundleStorageState)dep.getAttachment(BundleStorageState.class);
        if (this.storageState == null) {
            String location = dep.getLocation();
            VirtualFile rootFile = dep.getRoot();
            try {
                BundleStoragePlugin storagePlugin = this.getFrameworkState().getBundleStoragePlugin();
                this.storageState = storagePlugin.createStorageState(this.getBundleId(), location, rootFile);
                dep.addAttachment(BundleStorageState.class, (Object)this.storageState);
            }
            catch (IOException ex) {
                throw new BundleException("Cannot setup storage for: " + rootFile, (Throwable)ex);
            }
        }
        return this.storageState;
    }

    BundleStorageState createStorageState(String location, VirtualFile rootFile) throws BundleException {
        BundleStorageState storageState;
        try {
            BundleStoragePlugin storagePlugin = this.getFrameworkState().getBundleStoragePlugin();
            storageState = storagePlugin.createStorageState(this.getBundleId(), location, rootFile);
        }
        catch (IOException ex) {
            throw new BundleException("Cannot setup storage for: " + rootFile, (Throwable)ex);
        }
        return storageState;
    }

    void refresh() throws BundleException {
        this.assertNotUninstalled();
        if (!this.isResolved()) {
            throw new IllegalStateException("Attempt to refresh an unresolved bundle: " + this);
        }
        ResolverPlugin resolverPlugin = this.getFrameworkState().getResolverPlugin();
        ModuleManagerPlugin moduleManager = this.getFrameworkState().getModuleManagerPlugin();
        for (UserBundleRevision rev : this.getRevisions()) {
            XModule resModule = rev.getResolverModule();
            resolverPlugin.removeModule(resModule);
            ModuleIdentifier identifier = rev.getModuleIdentifier();
            moduleManager.removeModule(identifier);
        }
        UserBundleRevision currentRev = this.getCurrentRevision();
        this.clearRevisions();
        FrameworkEventsPlugin eventsPlugin = this.getFrameworkState().getFrameworkEventsPlugin();
        eventsPlugin.fireBundleEvent(this, 64);
        currentRev.refreshRevision(this.getOSGiMetaData());
        resolverPlugin.addModule(currentRev.getResolverModule());
        this.changeState(2);
    }

    @Override
    void uninstallInternal() throws BundleException {
        this.assertNotUninstalled();
        this.headersOnUninstall = this.getHeaders(null);
        BundleInstallHandler installHandler = this.getCoreServices().getInstallHandler();
        installHandler.uninstallBundle(this.getDeployment());
        log.infof("Bundle uninstalled: %s", (Object)this);
    }
}

