/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.transport;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.counters.CounterRepository;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.common.injection.InjectionHelper;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.spi.metadata.injection.InjectionsMetaData;
import org.jboss.wsf.stack.cxf.management.InstrumentationManagerExtImpl;

public class ServletHelper {
    public static final String ENABLE_CXF_MANAGEMENT = "enable.cxf.management";

    public static Endpoint initEndpoint(ServletConfig servletConfig, String servletName) {
        ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
        SPIProvider spiProvider = SPIProviderResolver.getInstance((ClassLoader)cl).getProvider();
        EndpointRegistry epRegistry = ((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class, cl)).getEndpointRegistry();
        ServletContext context = servletConfig.getServletContext();
        String contextPath = context.getContextPath();
        return ServletHelper.initServiceEndpoint(epRegistry, contextPath, servletName);
    }

    private static Endpoint initServiceEndpoint(EndpointRegistry epRegistry, String contextPath, String servletName) {
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        Endpoint endpoint = null;
        for (ObjectName sepId : epRegistry.getEndpoints()) {
            String propContext = sepId.getKeyProperty("context");
            String propEndpoint = sepId.getKeyProperty("endpoint");
            if (!servletName.equals(propEndpoint) || !contextPath.equals(propContext)) continue;
            endpoint = epRegistry.getEndpoint(sepId);
            break;
        }
        if (endpoint == null) {
            ObjectName oname = ObjectNameFactory.create((String)("jboss.ws:context=" + contextPath + "," + "endpoint" + "=" + servletName));
            throw new WebServiceException("Cannot obtain endpoint for: " + oname);
        }
        ServletHelper.injectServiceAndHandlerResources(endpoint);
        return endpoint;
    }

    private static void injectServiceAndHandlerResources(Endpoint endpoint) {
        ServerFactoryBean factory = (ServerFactoryBean)endpoint.getAttachment(ServerFactoryBean.class);
        if (factory != null) {
            InjectionsMetaData metadata = (InjectionsMetaData)endpoint.getAttachment(InjectionsMetaData.class);
            Context jndiContext = endpoint.getJNDIContext();
            List chain = ((JaxWsEndpointImpl)factory.getServer().getEndpoint()).getJaxwsBinding().getHandlerChain();
            if (chain != null) {
                for (Handler handler : chain) {
                    InjectionHelper.injectResources((Object)handler, (InjectionsMetaData)metadata, (Context)jndiContext);
                    InjectionHelper.callPostConstructMethod((Object)handler);
                }
            }
        }
    }

    public static void callPreDestroy(Endpoint endpoint) {
        ServerFactoryBean factory = (ServerFactoryBean)endpoint.getAttachment(ServerFactoryBean.class);
        if (factory != null && Deployment.DeploymentType.JAXWS_EJB3 != endpoint.getService().getDeployment().getType() && factory.getServiceBean() != null) {
            InjectionHelper.callPreDestroyMethod((Object)factory.getServiceBean());
        }
    }

    public static void callRequestHandler(HttpServletRequest req, HttpServletResponse res, ServletContext ctx, Bus bus, Endpoint endpoint) throws ServletException {
        try {
            BusFactory.setThreadDefaultBus((Bus)bus);
            EndpointAssociation.setEndpoint((Endpoint)endpoint);
            RequestHandler requestHandler = endpoint.getRequestHandler();
            requestHandler.handleHttpRequest(endpoint, req, res, ctx);
        }
        catch (IOException ioe) {
            throw new ServletException((Throwable)ioe);
        }
        finally {
            EndpointAssociation.removeEndpoint();
            BusFactory.setThreadDefaultBus(null);
        }
    }

    public static void registerInstrumentManger(Bus bus, ServletContext svCtx) throws ServletException {
        if (svCtx.getInitParameter(ENABLE_CXF_MANAGEMENT) != null && "true".equalsIgnoreCase(svCtx.getInitParameter(ENABLE_CXF_MANAGEMENT))) {
            InstrumentationManagerExtImpl instrumentationManagerImpl = new InstrumentationManagerExtImpl();
            instrumentationManagerImpl.setBus(bus);
            instrumentationManagerImpl.setEnabled(true);
            instrumentationManagerImpl.initMBeanServer();
            instrumentationManagerImpl.register();
            bus.setExtension((Object)instrumentationManagerImpl, InstrumentationManager.class);
            CounterRepository couterRepository = new CounterRepository();
            couterRepository.setBus(bus);
            try {
                Method method = CounterRepository.class.getDeclaredMethod("registerInterceptorsToBus", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)couterRepository, new Object[0]);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }
}

