/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.concurrency.impl;

import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.LockType;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.jboss.ejb3.concurrency.impl.EJBReadWriteLock;
import org.jboss.ejb3.concurrency.spi.LockableComponent;
import org.jboss.logging.Logger;

public abstract class ContainerManagedConcurrencyInterceptor {
    private static final Logger logger = Logger.getLogger(ContainerManagedConcurrencyInterceptor.class);
    private ReadWriteLock readWriteLock = new EJBReadWriteLock();

    protected abstract LockableComponent getLockableComponent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object invoke(InvocationContext invocationContext) throws Exception {
        boolean success;
        LockableComponent lockableComponent = this.getLockableComponent();
        Method invokedMethod = invocationContext.getMethod();
        if (invokedMethod == null) {
            throw new IllegalArgumentException("Invocation context: " + invocationContext + " cannot be processed because it's not applicable for a method invocation");
        }
        Lock lock = this.getLock(lockableComponent, invokedMethod);
        AccessTimeout defaultAccessTimeout = lockableComponent.getDefaultAccessTimeout();
        long time = defaultAccessTimeout.value();
        TimeUnit unit = defaultAccessTimeout.unit();
        AccessTimeout accessTimeoutOnMethod = lockableComponent.getAccessTimeout(invokedMethod);
        if (accessTimeoutOnMethod != null) {
            if (accessTimeoutOnMethod.value() < 0L) {
                logger.debug((Object)("Ignoring a negative @AccessTimeout value: " + accessTimeoutOnMethod.value() + " and timeout unit: " + accessTimeoutOnMethod.unit().name() + ". Will default to timeout value: " + defaultAccessTimeout.value() + " and timeout unit: " + defaultAccessTimeout.unit().name()));
            } else {
                time = accessTimeoutOnMethod.value();
                unit = accessTimeoutOnMethod.unit();
            }
        }
        if (!(success = lock.tryLock(time, unit))) {
            throw new ConcurrentAccessTimeoutException("EJB 3.1 PFD2 4.8.5.5.1 concurrent access timeout on " + invocationContext + " - could not obtain lock within " + time + unit.name());
        }
        try {
            Object object = invocationContext.proceed();
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    private Lock getLock(LockableComponent lockableComponent, Method method) {
        LockType lockType = lockableComponent.getLockType(method);
        switch (lockType) {
            case READ: {
                return this.readWriteLock.readLock();
            }
            case WRITE: {
                return this.readWriteLock.writeLock();
            }
        }
        throw new IllegalStateException("Illegal lock type " + lockType + " on " + method + " for component " + lockableComponent);
    }
}

