/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.jboss.arquillian.context.ContextManager;
import org.jboss.arquillian.context.ContextManagerBuilder;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.testenricher.msc.ServiceContainerAssociation;
import org.jboss.arquillian.testenricher.osgi.BundleAssociation;
import org.jboss.arquillian.testenricher.osgi.BundleContextAssociation;
import org.jboss.as.arquillian.service.ArquillianConfig;
import org.jboss.as.arquillian.service.ServerDeploymentManagerAssociation;
import org.jboss.as.arquillian.service.TCCLSetup;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.osgi.deployment.OSGiDeploymentAttachment;
import org.jboss.as.server.ServerController;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.client.ModelControllerServerDeploymentManager;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.ServiceNames;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.launch.Framework;

public class ArquillianService
implements Service<ArquillianService> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"arquillian", "testrunner"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.arquillian");
    private final InjectedValue<MBeanServer> injectedMBeanServer = new InjectedValue();
    private final InjectedValue<ServerController> injectedServerController = new InjectedValue();
    private final Map<String, ArquillianConfig> deployedTests = new HashMap<String, ArquillianConfig>();
    private final Map<String, CountDownLatch> waitingTests = new HashMap<String, CountDownLatch>();
    private JMXTestRunner jmxTestRunner;
    public static final String TEST_CLASS_PROPERTY = "org.jboss.as.arquillian.testClass";

    public static void addService(ServiceTarget serviceTarget) {
        ArquillianService service = new ArquillianService();
        ServiceBuilder serviceBuilder = serviceTarget.addService(SERVICE_NAME, (Service)service);
        serviceBuilder.addDependency(Services.JBOSS_SERVER_CONTROLLER, ServerController.class, service.injectedServerController);
        serviceBuilder.addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, service.injectedMBeanServer);
        serviceBuilder.install();
    }

    public synchronized void start(StartContext context) throws StartException {
        log.debugf("Starting Arquillian Test Runner", new Object[0]);
        MBeanServer mbeanServer = (MBeanServer)this.injectedMBeanServer.getValue();
        ServiceContainer serviceContainer = context.getController().getServiceContainer();
        final TestClassLoaderImpl testClassLoader = new TestClassLoaderImpl(serviceContainer);
        try {
            this.jmxTestRunner = new JMXTestRunner(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public TestResult runTestMethod(String className, String methodName, Map<String, String> props) {
                    Map<String, Object> properties = Collections.singletonMap(ArquillianService.TEST_CLASS_PROPERTY, className);
                    ContextManager contextManager = this.initializeContextManager(className, properties);
                    try {
                        TestResult testResult = super.runTestMethod(className, methodName, props);
                        return testResult;
                    }
                    finally {
                        contextManager.teardown(properties);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public InputStream runTestMethodEmbedded(String className, String methodName, Map<String, String> props) {
                    Map<String, Object> properties = Collections.singletonMap(ArquillianService.TEST_CLASS_PROPERTY, className);
                    ContextManager contextManager = this.initializeContextManager(className, properties);
                    try {
                        InputStream inputStream = super.runTestMethodEmbedded(className, methodName, props);
                        return inputStream;
                    }
                    finally {
                        contextManager.teardown(properties);
                    }
                }

                protected JMXTestRunner.TestClassLoader getTestClassLoader() {
                    return testClassLoader;
                }

                private ContextManager initializeContextManager(String className, Map<String, Object> properties) {
                    ContextManagerBuilder builder = new ContextManagerBuilder();
                    ArquillianConfig config = ArquillianService.this.getConfig(className);
                    if (config != null) {
                        DeploymentUnit deployment = config.getDeploymentUnitContext();
                        Module module = (Module)deployment.getAttachment(Attachments.MODULE);
                        if (module != null) {
                            builder.add(new TCCLSetup((ClassLoader)module.getClassLoader()));
                        }
                        builder.addAll(deployment);
                    }
                    ContextManager contextManager = builder.build();
                    contextManager.setup(properties);
                    return contextManager;
                }
            };
            this.jmxTestRunner.registerMBean(mbeanServer);
        }
        catch (Throwable t) {
            throw new StartException("Failed to start Arquillian Test Runner", t);
        }
    }

    public synchronized void stop(StopContext context) {
        log.debugf("Stopping Arquillian Test Runner", new Object[0]);
        try {
            if (this.jmxTestRunner != null) {
                this.jmxTestRunner.unregisterMBean((MBeanServer)this.injectedMBeanServer.getValue());
            }
        }
        catch (Exception ex) {
            log.errorf((Throwable)ex, "Cannot stop Arquillian Test Runner", new Object[0]);
        }
    }

    public ArquillianService getValue() throws IllegalStateException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerDeployment(ArquillianConfig arqConfig) {
        Map<String, ArquillianConfig> map = this.deployedTests;
        synchronized (map) {
            for (String className : arqConfig.getTestClasses()) {
                this.deployedTests.put(className, arqConfig);
                CountDownLatch latch = this.waitingTests.remove(className);
                if (latch == null) continue;
                latch.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterDeployment(ArquillianConfig arqConfig) {
        Map<String, ArquillianConfig> map = this.deployedTests;
        synchronized (map) {
            for (String className : arqConfig.getTestClasses()) {
                this.deployedTests.remove(className);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArquillianConfig getConfig(String className) {
        CountDownLatch latch = null;
        Map<String, ArquillianConfig> map = this.deployedTests;
        synchronized (map) {
            ArquillianConfig config = this.deployedTests.get(className);
            if (config != null) {
                return config;
            }
            latch = new CountDownLatch(1);
            this.waitingTests.put(className, latch);
        }
        long end = System.currentTimeMillis() + 10000L;
        while (true) {
            try {
                latch.await(end - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
        Map<String, ArquillianConfig> map2 = this.deployedTests;
        synchronized (map2) {
            this.waitingTests.remove(className);
            return this.deployedTests.get(className);
        }
    }

    class TestClassLoaderImpl
    implements JMXTestRunner.TestClassLoader {
        private ServiceContainer serviceContainer;
        private ServerDeploymentManager deploymentManager;

        TestClassLoaderImpl(ServiceContainer serviceContainer) {
            this.serviceContainer = serviceContainer;
            this.deploymentManager = new ModelControllerServerDeploymentManager((ModelController)ArquillianService.this.injectedServerController.getValue());
        }

        public Class<?> loadTestClass(String className) throws ClassNotFoundException {
            ArquillianConfig arqConfig = ArquillianService.this.getConfig(className);
            if (arqConfig == null) {
                throw new ClassNotFoundException(className);
            }
            if (!arqConfig.getTestClasses().contains(className)) {
                throw new ClassNotFoundException(className);
            }
            DeploymentUnit depunit = arqConfig.getDeploymentUnitContext();
            Module module = (Module)depunit.getAttachment(Attachments.MODULE);
            Deployment osgidep = OSGiDeploymentAttachment.getDeployment((DeploymentUnit)depunit);
            if (module != null && osgidep != null) {
                throw new IllegalStateException("Found MODULE attachment for Bundle deployment: " + depunit);
            }
            Class testClass = null;
            if (module != null) {
                ServiceContainerAssociation.setServiceContainer((ServiceContainer)this.serviceContainer);
                ServerDeploymentManagerAssociation.setServerDeploymentManager(this.deploymentManager);
                testClass = module.getClassLoader().loadClass(className);
            } else if (osgidep != null) {
                Bundle bundle = (Bundle)osgidep.getAttachment(Bundle.class);
                BundleAssociation.setBundle((Bundle)bundle);
                ServiceContainerAssociation.setServiceContainer((ServiceContainer)this.serviceContainer);
                ServerDeploymentManagerAssociation.setServerDeploymentManager(this.deploymentManager);
                Framework framework = this.awaitActiveOSGiFramework();
                BundleContextAssociation.setBundleContext((BundleContext)framework.getBundleContext());
                testClass = bundle.loadClass(className);
            }
            if (testClass == null) {
                throw new ClassNotFoundException(className);
            }
            return testClass;
        }

        public ClassLoader getServiceClassLoader() {
            return ArquillianService.class.getClassLoader();
        }

        void assertServiceState(ServiceName serviceName, ServiceController.State expState, long timeout) {
            ServiceController.State state;
            ServiceController controller = this.serviceContainer.getService(serviceName);
            ServiceController.State state2 = state = controller != null ? controller.getState() : null;
            while ((state == null || state != expState) && timeout > 0L) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                controller = this.serviceContainer.getService(serviceName);
                state = controller != null ? controller.getState() : null;
                timeout -= 100L;
            }
            if (expState != state) {
                throw new IllegalArgumentException(serviceName + " expected: " + expState + " but was " + state);
            }
        }

        private Framework awaitActiveOSGiFramework() {
            ServiceController controller = this.serviceContainer.getRequiredService(ServiceNames.FRAMEWORK_ACTIVE);
            if (controller.getState() != ServiceController.State.UP) {
                controller.setMode(ServiceController.Mode.ACTIVE);
                this.assertServiceState(ServiceNames.FRAMEWORK_ACTIVE, ServiceController.State.UP, 10000L);
            }
            return (Framework)controller.getValue();
        }
    }
}

